/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class IconTableCellRenderer
extends DefaultTableCellRenderer {
    Icon defaultIcon;
    static AbstractButton button = new AbstractButton(){};

    public IconTableCellRenderer() {
    }

    public IconTableCellRenderer(Icon defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Icon icon = (Icon)value;
        this.setIcon(null);
        this.setText("width=" + icon.getIconWidth() + ", height=" + icon.getIconHeight());
        this.setBackground(this.getCorrectBackground(table, isSelected));
        try {
            this.createIcon(icon, this);
        }
        catch (ClassCastException cce) {
            try {
                String className = cce.getMessage();
                className = className.substring(className.lastIndexOf(" ") + 1);
                Class<?> clazz = Class.forName(className);
                this.createIcon(icon, (JComponent)clazz.newInstance());
            }
            catch (InstantiationException ie) {
                try {
                    this.createIcon(icon, button);
                }
                catch (ClassCastException cce2) {
                }
                catch (InstantiationException ie2) {
                }
            }
            catch (IllegalAccessException iae) {
            }
            catch (ClassNotFoundException cnfe) {}
        }
        catch (InstantiationException ie3) {
            // empty catch block
        }
        if (this.getIcon() == null) {
            try {
                this.createIcon(this.defaultIcon == null ? new XIcon(icon.getIconWidth(), icon.getIconHeight()) : this.defaultIcon, null);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.setBackground(this.getCorrectBackground(table, isSelected));
        return this;
    }

    private void createIcon(Icon icon, JComponent component) throws ClassCastException, InstantiationException {
        BufferedImage image = new BufferedImage(icon.getIconWidth() + 2, icon.getIconHeight() + 2, 2);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(component, g, 2, 2);
        this.setIcon(new ImageIcon(image));
    }

    private Color getCorrectBackground(JTable table, boolean isSelected) {
        return isSelected ? table.getSelectionBackground() : table.getBackground();
    }

    public static void setRowHeightsForIcons(JTable table) {
        TableModel model = table.getModel();
        for (int col = 0; col < table.getColumnCount(); ++col) {
            if (!Icon.class.isAssignableFrom(table.getColumnClass(col)) || !(table.getDefaultRenderer(Icon.class) instanceof IconTableCellRenderer)) continue;
            for (int row = 0; row < model.getRowCount(); ++row) {
                Icon icon = (Icon)model.getValueAt(row, col);
                table.setRowHeight(table.convertRowIndexToView(row), Math.max(table.getRowHeight(row), icon.getIconHeight() + 2));
            }
        }
    }

    static {
        button.setModel(new DefaultButtonModel());
    }

    class XIcon
    implements Icon {
        int width;
        int height;

        XIcon(int width, int height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawRect(x, y, this.width, this.height);
            g.drawLine(x, y, x + this.width, y + this.height);
            g.drawLine(x + this.width, y, x, y + this.height);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }
}

