/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing.table;

import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;

public class ComboBoxTableEditor
extends DefaultCellEditor {
    private int relatedColumn;
    protected HashMap<Object, ComboBoxModel> models = new HashMap();

    public ComboBoxTableEditor() {
        this(-1);
    }

    public ComboBoxTableEditor(int relatedColumn) {
        this(new JComboBox(), relatedColumn);
    }

    public ComboBoxTableEditor(JComboBox comboBox, int relatedColumn) {
        super(comboBox);
        this.relatedColumn = relatedColumn;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        ComboBoxModel model = this.getModelForRow(table, value, row, column);
        if (model == null) {
            return null;
        }
        JComboBox comboBox = (JComboBox)this.getComponent();
        comboBox.setModel(model);
        comboBox.setSelectedItem(value);
        return comboBox;
    }

    protected ComboBoxModel getModelForRow(JTable table, Object value, int row, int column) {
        if (this.relatedColumn == -1) {
            this.relatedColumn = table.convertColumnIndexToModel(column) - 1;
        }
        Object key = table.getModel().getValueAt(row, this.relatedColumn);
        ComboBoxModel model = this.models.get(key);
        return model;
    }

    public void addModel(Object key, List items) {
        Vector vector = new Vector(items.size());
        for (Object o : items) {
            vector.add(o);
        }
        this.addModel(key, vector);
    }

    public void addModel(Object key, Vector items) {
        this.addModel(key, new DefaultComboBoxModel(items));
    }

    public void addModel(Object key, Object[] items) {
        this.addModel(key, new DefaultComboBoxModel<Object>(items));
    }

    public void addModel(Object key, ComboBoxModel model) {
        this.models.put(key, model);
    }
}

