/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;

public class VisibleCaretListener
implements CaretListener {
    private int visiblePixels;

    public VisibleCaretListener() {
        this(2);
    }

    public VisibleCaretListener(int visiblePixels) {
        this.setVisiblePixels(visiblePixels);
    }

    public int getVisiblePixels() {
        return this.visiblePixels;
    }

    public void setVisiblePixels(int visiblePixels) {
        this.visiblePixels = visiblePixels;
    }

    @Override
    public void caretUpdate(final CaretEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    JTextComponent component = (JTextComponent)e.getSource();
                    int position = component.getCaretPosition();
                    Rectangle r = component.modelToView(position);
                    r.x += VisibleCaretListener.this.visiblePixels;
                    component.scrollRectToVisible(r);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

