/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabFocusHandler
implements ChangeListener,
PropertyChangeListener {
    public static final int RESET_FOCUS = 0;
    public static final int RETAIN_FOCUS = 1;
    private HashMap<Component, Component> tabFocus = new HashMap();
    private HashSet<Component> exceptions;
    private JTabbedPane tabbedPane;
    private int focusPolicy;

    public TabFocusHandler(JTabbedPane tabbedPane) {
        this(tabbedPane, 1);
    }

    public TabFocusHandler(JTabbedPane tabbedPane, int focusPolicy) {
        if (focusPolicy != 0 && focusPolicy != 1) {
            throw new IllegalArgumentException("Invalid focus policy");
        }
        this.tabbedPane = tabbedPane;
        this.focusPolicy = focusPolicy;
        tabbedPane.addChangeListener(this);
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener("permanentFocusOwner", this);
    }

    public void addException(int index) {
        if (this.exceptions == null) {
            this.exceptions = new HashSet();
        }
        Component key = this.tabbedPane.getComponentAt(index);
        this.exceptions.add(key);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Component key = this.tabbedPane.getComponentAt(this.tabbedPane.getSelectedIndex());
        if (key == null) {
            return;
        }
        Component value = this.tabFocus.get(key);
        if (value == null) {
            key.transferFocus();
            this.tabFocus.put(key, value);
        } else {
            value.requestFocusInWindow();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Component value;
        if (this.exceptions == null && this.focusPolicy == 0) {
            return;
        }
        Component key = this.tabbedPane.getComponentAt(this.tabbedPane.getSelectedIndex());
        if (this.exceptions != null) {
            if (this.focusPolicy == 0 && !this.exceptions.contains(key)) {
                return;
            }
            if (this.focusPolicy == 1 && this.exceptions.contains(key)) {
                return;
            }
        }
        if ((value = (Component)e.getNewValue()) != null && SwingUtilities.isDescendingFrom(value, key)) {
            this.tabFocus.put(key, value);
        }
    }
}

