/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JSplitPane;

public class SplitPaneSynchronizer
implements PropertyChangeListener {
    private static final String DIVIDER_LOCATION = "dividerLocation";
    private ArrayList<JSplitPane> splitPanes;

    public SplitPaneSynchronizer(JSplitPane ... splitPanes) {
        this.splitPanes = new ArrayList(splitPanes.length);
        for (JSplitPane splitPane : splitPanes) {
            this.addSplitPane(splitPane);
        }
    }

    public void addSplitPane(JSplitPane splitPane) {
        splitPane.addPropertyChangeListener(DIVIDER_LOCATION, this);
        this.splitPanes.add(splitPane);
    }

    public void removeSplitPane(JSplitPane splitPane) {
        splitPane.removePropertyChangeListener(DIVIDER_LOCATION, this);
        this.splitPanes.remove(splitPane);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object source = e.getSource();
        int location = (Integer)e.getNewValue();
        for (JSplitPane splitPane : this.splitPanes) {
            if (splitPane == source || splitPane.getDividerLocation() == location) continue;
            splitPane.setDividerLocation(location);
        }
    }
}

