/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

public class ScrollBarToolTip
implements MouseListener,
MouseMotionListener {
    private static final int GAP = 5;
    private static final int ADJUSTMENT = 20;
    private JScrollBar scrollBar;
    private Style style;
    private Position position;
    private Point pressedPoint;
    private Popup popup;
    private JToolTip toolTip;

    public ScrollBarToolTip(JScrollBar scrollBar) {
        this(scrollBar, Style.FIXED_PRESSED, Position.INSIDE);
    }

    public ScrollBarToolTip(JScrollBar scrollBar, Style style, Position position) {
        this.scrollBar = scrollBar;
        this.setStyle(style);
        this.setPosition(position);
        scrollBar.addMouseListener(this);
        scrollBar.addMouseMotionListener(this);
        this.toolTip = scrollBar.createToolTip();
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    protected void showToolTip(MouseEvent event) {
        this.toolTip.setTipText(this.getToolTipText(event));
        Point toolTipLocation = this.getToolTipLocation(event);
        if (this.popup != null) {
            this.popup.hide();
        }
        PopupFactory factory = PopupFactory.getSharedInstance();
        this.popup = factory.getPopup(this.scrollBar, this.toolTip, toolTipLocation.x, toolTipLocation.y);
        this.popup.show();
    }

    protected String getToolTipText(MouseEvent event) {
        BoundedRangeModel model = this.scrollBar.getModel();
        int percent = model.getValue() * 100 / (model.getMaximum() - model.getExtent());
        return percent + "%";
    }

    protected Point getToolTipLocation(MouseEvent event) {
        Point toolTipLocation = this.scrollBar.getOrientation() == 0 ? new Point(this.getHorizontalX(event), this.getHorizontalY(event)) : new Point(this.getVerticalX(event), this.getVerticalY(event));
        Point scrollBarLocation = this.scrollBar.getLocationOnScreen();
        int x = scrollBarLocation.x + toolTipLocation.x;
        int y = scrollBarLocation.y + toolTipLocation.y;
        Window window = SwingUtilities.windowForComponent(this.scrollBar);
        Rectangle r = window.getBounds();
        Insets insets = window.getInsets();
        Dimension d = this.toolTip.getPreferredSize();
        int xMax = r.x + r.width - d.width - insets.right;
        int yMax = r.y + r.height - d.height - insets.bottom;
        x = Math.min(Math.max(x, r.x + insets.left), xMax);
        y = Math.min(Math.max(y, r.y + insets.top), yMax);
        toolTipLocation.setLocation(x, y);
        return toolTipLocation;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pressedPoint = e.getPoint();
        this.showToolTip(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.popup.hide();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.showToolTip(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private int getHorizontalX(MouseEvent e) {
        Style orientationStyle = this.style.getOrientationStyle(this.scrollBar);
        if (orientationStyle == Style.FIXED_PRESSED) {
            return this.pressedPoint.x;
        }
        if (orientationStyle == Style.FIXED_START) {
            return 0;
        }
        if (orientationStyle == Style.FIXED_END) {
            return this.scrollBar.getWidth() - this.toolTip.getPreferredSize().width;
        }
        Position orientationPosition = this.position.getOrientationPosition(this.scrollBar);
        int x = e.getX();
        if (orientationPosition == Position.INSIDE_EDGE || orientationPosition == Position.CENTER || orientationPosition == Position.OUTSIDE_EDGE) {
            x = orientationStyle == Style.FLOAT_START ? (x -= 20 + this.toolTip.getPreferredSize().width) : (x += 20);
        }
        x = Math.min(Math.max(x, 0), this.scrollBar.getWidth() - this.toolTip.getPreferredSize().width - 1);
        return x;
    }

    private int getVerticalX(MouseEvent e) {
        Position orientationPosition = this.position.getOrientationPosition(this.scrollBar);
        int x = 0;
        switch (orientationPosition) {
            case CENTER: {
                x = (this.scrollBar.getWidth() - this.toolTip.getPreferredSize().width) / 2;
                break;
            }
            case INSIDE: {
                x = -5 - this.toolTip.getPreferredSize().width;
                break;
            }
            case OUTSIDE: {
                x = this.scrollBar.getWidth() + 5;
                break;
            }
            case OUTSIDE_EDGE: {
                x = this.scrollBar.getWidth() - this.toolTip.getPreferredSize().width;
            }
        }
        return x;
    }

    private int getHorizontalY(MouseEvent e) {
        Position orientationPosition = this.position.getOrientationPosition(this.scrollBar);
        int y = 0;
        switch (orientationPosition) {
            case CENTER: {
                y = (this.scrollBar.getHeight() - this.toolTip.getPreferredSize().height) / 2;
                break;
            }
            case INSIDE: {
                y = -5 - this.toolTip.getPreferredSize().height;
                break;
            }
            case OUTSIDE: {
                y = this.scrollBar.getHeight() + 5;
                break;
            }
            case OUTSIDE_EDGE: {
                y = this.scrollBar.getHeight() - this.toolTip.getPreferredSize().height;
            }
        }
        return y;
    }

    private int getVerticalY(MouseEvent e) {
        Style orientationStyle = this.style.getOrientationStyle(this.scrollBar);
        if (orientationStyle == Style.FIXED_PRESSED) {
            return this.pressedPoint.y;
        }
        if (orientationStyle == Style.FIXED_START) {
            return 0;
        }
        if (orientationStyle == Style.FIXED_END) {
            return this.scrollBar.getHeight() - this.toolTip.getPreferredSize().height;
        }
        Position orientationPosition = this.position.getOrientationPosition(this.scrollBar);
        int y = e.getY();
        if (orientationPosition == Position.INSIDE_EDGE || orientationPosition == Position.CENTER || orientationPosition == Position.OUTSIDE_EDGE) {
            y = orientationStyle == Style.FLOAT_START ? (y -= 20 + this.toolTip.getPreferredSize().height) : (y += 20);
        }
        y = Math.min(Math.max(y, 0), this.scrollBar.getHeight() - this.toolTip.getPreferredSize().height - 1);
        return y;
    }

    public static enum Position {
        CENTER,
        INSIDE,
        INSIDE_EDGE,
        OUTSIDE,
        OUTSIDE_EDGE;


        public Position getOrientationPosition(JScrollBar scrollBar) {
            if (scrollBar.getComponentOrientation().isLeftToRight() || scrollBar.getOrientation() == 0) {
                return this;
            }
            switch (this) {
                case INSIDE: {
                    return OUTSIDE;
                }
                case OUTSIDE: {
                    return INSIDE;
                }
                case INSIDE_EDGE: {
                    return OUTSIDE_EDGE;
                }
                case OUTSIDE_EDGE: {
                    return INSIDE_EDGE;
                }
            }
            return this;
        }
    }

    public static enum Style {
        FIXED_PRESSED,
        FIXED_START,
        FIXED_END,
        FLOAT_START,
        FLOAT_END;


        public Style getOrientationStyle(JScrollBar scrollBar) {
            if (scrollBar.getComponentOrientation().isLeftToRight() || scrollBar.getOrientation() == 1) {
                return this;
            }
            switch (this) {
                case FIXED_START: {
                    return FIXED_END;
                }
                case FIXED_END: {
                    return FIXED_START;
                }
                case FLOAT_START: {
                    return FLOAT_END;
                }
                case FLOAT_END: {
                    return FLOAT_START;
                }
            }
            return this;
        }
    }
}

