/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import com.wordpress.tipsforjava.swing.text.ProtectedDocument;
import com.wordpress.tipsforjava.swing.text.ProtectedHighlighter;
import java.awt.Color;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;

public class ProtectedTextComponent {
    private JTextComponent component;
    private ProtectedHighlighter highlighter;
    private ProtectedDocument document;

    public ProtectedTextComponent(JTextComponent component) {
        this(component, null);
    }

    public ProtectedTextComponent(JTextComponent component, Color color) {
        this.component = component;
        this.document = new ProtectedDocument(component);
        this.highlighter = new ProtectedHighlighter(component, color);
    }

    public void protectText(int start, int end) {
        this.document.protect(start, end);
        this.highlighter.addHighlight(start, end + 1);
    }

    public void protectLine(int line) {
        this.protectLines(line, line);
    }

    public void protectLines(int firstLine, int lastLine) {
        Element root = this.component.getDocument().getDefaultRootElement();
        firstLine = Math.max(firstLine, 0);
        firstLine = Math.min(firstLine, root.getElementCount() - 1);
        Element firstElement = root.getElement(firstLine);
        lastLine = Math.max(lastLine, 0);
        lastLine = Math.min(lastLine, root.getElementCount() - 1);
        Element lastElement = root.getElement(lastLine);
        int start = firstElement.getStartOffset();
        int end = lastElement.getEndOffset();
        this.document.protect(start - 1, end - 1);
        this.highlighter.addHighlight(start, end);
    }
}

