/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class MenuScroller {
    private JMenu menu;
    private JPopupMenu popupMenu;
    private Component[] menuItems;
    private MenuScrollItem upItem;
    private MenuScrollItem downItem;
    private final MenuScrollListener menuListener = new MenuScrollListener();
    private int scrollCount;
    private int interval;
    private int topFixedCount;
    private int bottomFixedCount;
    private int firstIndex = 0;

    public static MenuScroller setScrollerFor(JMenu menu) {
        return new MenuScroller(menu);
    }

    public static MenuScroller setScrollerFor(JPopupMenu menu) {
        return new MenuScroller(menu);
    }

    public static MenuScroller setScrollerFor(JMenu menu, int scrollCount) {
        return new MenuScroller(menu, scrollCount);
    }

    public static MenuScroller setScrollerFor(JPopupMenu menu, int scrollCount) {
        return new MenuScroller(menu, scrollCount);
    }

    public static MenuScroller setScrollerFor(JMenu menu, int scrollCount, int interval) {
        return new MenuScroller(menu, scrollCount, interval);
    }

    public static MenuScroller setScrollerFor(JPopupMenu menu, int scrollCount, int interval) {
        return new MenuScroller(menu, scrollCount, interval);
    }

    public static MenuScroller setScrollerFor(JMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        return new MenuScroller(menu, scrollCount, interval, topFixedCount, bottomFixedCount);
    }

    public static MenuScroller setScrollerFor(JPopupMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        return new MenuScroller(menu, scrollCount, interval, topFixedCount, bottomFixedCount);
    }

    public MenuScroller(JMenu menu) {
        this(menu, 15);
    }

    public MenuScroller(JPopupMenu menu) {
        this(menu, 15);
    }

    public MenuScroller(JMenu menu, int scrollCount) {
        this(menu, scrollCount, 150);
    }

    public MenuScroller(JPopupMenu menu, int scrollCount) {
        this(menu, scrollCount, 150);
    }

    public MenuScroller(JMenu menu, int scrollCount, int interval) {
        this(menu, scrollCount, interval, 0, 0);
    }

    public MenuScroller(JPopupMenu menu, int scrollCount, int interval) {
        this(menu, scrollCount, interval, 0, 0);
    }

    public MenuScroller(JMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        this.setValues(scrollCount, interval, topFixedCount, bottomFixedCount);
        this.menu = menu;
        menu.addMenuListener(this.menuListener);
    }

    public MenuScroller(JPopupMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        this.setValues(scrollCount, interval, topFixedCount, bottomFixedCount);
        this.popupMenu = menu;
        menu.addPopupMenuListener(this.menuListener);
    }

    private void setValues(int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        if (scrollCount <= 0 || interval <= 0) {
            throw new IllegalArgumentException("scrollCount and interval must be greater than 0");
        }
        if (topFixedCount < 0 || bottomFixedCount < 0) {
            throw new IllegalArgumentException("topFixedCount and bottomFixedCount cannot be negative");
        }
        this.upItem = new MenuScrollItem(MenuIcon.UP, -1);
        this.downItem = new MenuScrollItem(MenuIcon.DOWN, 1);
        this.setScrollCount(scrollCount);
        this.setInterval(interval);
        this.setTopFixedCount(topFixedCount);
        this.setBottomFixedCount(bottomFixedCount);
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("interval must be greater than 0");
        }
        this.upItem.setInterval(interval);
        this.downItem.setInterval(interval);
        this.interval = interval;
    }

    public int getscrollCount() {
        return this.scrollCount;
    }

    public void setScrollCount(int scrollCount) {
        if (scrollCount <= 0) {
            throw new IllegalArgumentException("scrollCount must be greater than 0");
        }
        this.scrollCount = scrollCount;
        if (this.menu != null) {
            this.menu.doClick();
        }
        MenuSelectionManager.defaultManager().clearSelectedPath();
    }

    public int getTopFixedCount() {
        return this.topFixedCount;
    }

    public void setTopFixedCount(int topFixedCount) {
        this.firstIndex = Math.max(this.firstIndex, topFixedCount);
        this.topFixedCount = topFixedCount;
    }

    public int getBottomFixedCount() {
        return this.bottomFixedCount;
    }

    public void setBottomFixedCount(int bottomFixedCount) {
        this.bottomFixedCount = bottomFixedCount;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.removeMenuListener(this.menuListener);
            this.menu = null;
        }
        if (this.popupMenu != null) {
            this.popupMenu.removePopupMenuListener(this.menuListener);
            this.popupMenu = null;
        }
    }

    public void finalize() throws Throwable {
        this.dispose();
    }

    private void setMenuItems() {
        if (this.menu != null) {
            this.menuItems = this.menu.getMenuComponents();
        }
        if (this.popupMenu != null) {
            this.menuItems = this.popupMenu.getComponents();
        }
        if (this.menuItems.length > this.topFixedCount + this.scrollCount + this.bottomFixedCount) {
            this.refreshMenu();
        }
    }

    private void restoreMenuItems() {
        JComponent container = this.menu == null ? this.popupMenu : this.menu;
        container.removeAll();
        for (Component component : this.menuItems) {
            container.add(component);
        }
    }

    private void refreshMenu() {
        int i;
        this.firstIndex = Math.max(this.topFixedCount, this.firstIndex);
        this.firstIndex = Math.min(this.menuItems.length - this.bottomFixedCount - this.scrollCount, this.firstIndex);
        this.upItem.setEnabled(this.firstIndex > this.topFixedCount);
        this.downItem.setEnabled(this.firstIndex + this.scrollCount < this.menuItems.length - this.bottomFixedCount);
        JComponent container = this.menu == null ? this.popupMenu : this.menu;
        container.removeAll();
        for (i = 0; i < this.topFixedCount; ++i) {
            container.add(this.menuItems[i]);
        }
        if (this.topFixedCount > 0) {
            container.add(new JSeparator());
        }
        container.add(this.upItem);
        for (i = this.firstIndex; i < this.scrollCount + this.firstIndex; ++i) {
            container.add(this.menuItems[i]);
        }
        container.add(this.downItem);
        if (this.bottomFixedCount > 0) {
            container.add(new JSeparator());
        }
        for (i = this.menuItems.length - this.bottomFixedCount; i < this.menuItems.length; ++i) {
            container.add(this.menuItems[i]);
        }
        JComponent parent = (JComponent)this.upItem.getParent();
        parent.revalidate();
        parent.repaint();
    }

    private static enum MenuIcon implements Icon
    {
        UP(9, 1, 9),
        DOWN(1, 9, 1);

        final int[] xPoints = new int[]{1, 5, 9};
        final int[] yPoints;

        private MenuIcon(int ... yPoints) {
            this.yPoints = yPoints;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Dimension size = c.getSize();
            Graphics g2 = g.create(size.width / 2 - 5, size.height / 2 - 5, 10, 10);
            g2.setColor(Color.GRAY);
            g2.drawPolygon(this.xPoints, this.yPoints, 3);
            if (c.isEnabled()) {
                g2.setColor(Color.BLACK);
                g2.fillPolygon(this.xPoints, this.yPoints, 3);
            }
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    private class MenuScrollListener
    implements MenuListener,
    PopupMenuListener {
        private MenuScrollListener() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            MenuScroller.this.setMenuItems();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            MenuScroller.this.restoreMenuItems();
        }

        @Override
        public void menuCanceled(MenuEvent e) {
            MenuScroller.this.restoreMenuItems();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            MenuScroller.this.setMenuItems();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            MenuScroller.this.restoreMenuItems();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            MenuScroller.this.restoreMenuItems();
        }
    }

    private class MenuScrollTimer
    extends Timer {
        public MenuScrollTimer(final int increment, int interval) {
            super(interval, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuScroller.this.firstIndex += increment;
                    MenuScroller.this.refreshMenu();
                }
            });
        }
    }

    private class MenuScrollItem
    extends JMenuItem
    implements ChangeListener {
        private MenuScrollTimer timer;

        public MenuScrollItem(MenuIcon icon, int increment) {
            this.setIcon(icon);
            this.setDisabledIcon(icon);
            this.timer = new MenuScrollTimer(increment, MenuScroller.this.interval);
            this.addChangeListener(this);
        }

        public void setInterval(int interval) {
            this.timer.setDelay(interval);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.isArmed() && !this.timer.isRunning()) {
                this.timer.start();
            }
            if (!this.isArmed() && this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }
}

