/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class FormScroller
implements PropertyChangeListener {
    private JScrollPane scrollPane;
    private Type type;
    private Insets scrollInsets = new Insets(0, 0, 0, 0);
    private boolean scrollingEnabled;
    private Point lastLocation = new Point();

    public FormScroller(JScrollPane scrollPane) {
        this(scrollPane, Type.COMPONENT);
    }

    public FormScroller(JScrollPane scrollPane, Type type) {
        this.scrollPane = scrollPane;
        this.setType(type);
        this.setScrollingEnabled(true);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Insets getScrollInsets() {
        return this.scrollInsets;
    }

    public void setScrollInsets(Insets scrollInsets) {
        this.scrollInsets = scrollInsets;
    }

    public boolean isScrollingEnabled() {
        return this.scrollingEnabled;
    }

    public void setScrollingEnabled(boolean scrollingEnabled) {
        this.scrollingEnabled = scrollingEnabled;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this);
        if (scrollingEnabled) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Component component = (Component)evt.getNewValue();
        if (component == null) {
            return;
        }
        JComponent view = (JComponent)this.scrollPane.getViewport().getView();
        if (!SwingUtilities.isDescendingFrom(component, view)) {
            return;
        }
        Rectangle bounds = this.determineScrollBounds(component, view);
        view.scrollRectToVisible(bounds);
    }

    protected Rectangle determineScrollBounds(Component component, JComponent view) {
        Rectangle bounds = null;
        bounds = this.type == Type.COMPONENT ? this.determineComponentBounds(component, view) : (this.type == Type.PARENT ? this.determineParentBounds(component, view) : this.determineChildBounds(component, view));
        Point location = component.getLocation();
        location = SwingUtilities.convertPoint(component.getParent(), location, view);
        if (location.x < this.lastLocation.x) {
            bounds.x -= this.scrollInsets.left;
        } else {
            bounds.width += this.scrollInsets.right;
        }
        if (location.y < this.lastLocation.y) {
            bounds.y -= this.scrollInsets.top;
        } else {
            bounds.height += this.scrollInsets.bottom;
        }
        this.lastLocation = location;
        return bounds;
    }

    private Rectangle determineComponentBounds(Component component, JComponent view) {
        Rectangle bounds = component.getBounds();
        bounds = SwingUtilities.convertRectangle(component.getParent(), bounds, view);
        return bounds;
    }

    private Rectangle determineParentBounds(Component component, JComponent view) {
        Container parent = component.getParent();
        Rectangle bounds = parent.getBounds();
        bounds = SwingUtilities.convertRectangle(parent.getParent(), bounds, view);
        if (this.rectangleFits(bounds)) {
            return bounds;
        }
        return this.determineComponentBounds(component, view);
    }

    private Rectangle determineChildBounds(Component component, JComponent view) {
        Component child = null;
        for (Component c : view.getComponents()) {
            if (!SwingUtilities.isDescendingFrom(component, c)) continue;
            child = c;
            break;
        }
        Rectangle bounds = child.getBounds();
        bounds = SwingUtilities.convertRectangle(child.getParent(), bounds, view);
        if (this.rectangleFits(bounds)) {
            return bounds;
        }
        return this.determineParentBounds(component, view);
    }

    private boolean rectangleFits(Rectangle bounds) {
        Dimension viewport = this.scrollPane.getViewport().getSize();
        return bounds.width <= viewport.width && bounds.height <= viewport.height;
    }

    public static enum Type {
        COMPONENT,
        PARENT,
        CHILD;

    }
}

