/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class EditListAction
extends AbstractAction {
    private JList list;
    private JPopupMenu editPopup;
    private JTextField editTextField;
    private Class<?> modelClass;

    public EditListAction() {
        this.setModelClass(DefaultListModel.class);
    }

    protected void setModelClass(Class modelClass) {
        this.modelClass = modelClass;
    }

    protected void applyValueToModel(String value, ListModel model, int row) {
        DefaultListModel dlm = (DefaultListModel)model;
        dlm.set(row, value);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.list = (JList)e.getSource();
        ListModel model = this.list.getModel();
        if (!this.modelClass.isAssignableFrom(model.getClass())) {
            return;
        }
        if (this.editPopup == null) {
            this.createEditPopup();
        }
        int row = this.list.getSelectedIndex();
        Rectangle r = this.list.getCellBounds(row, row);
        this.editPopup.setPreferredSize(new Dimension(r.width, r.height));
        this.editPopup.show(this.list, r.x, r.y);
        this.editTextField.setText(this.list.getSelectedValue().toString());
        this.editTextField.selectAll();
        this.editTextField.requestFocusInWindow();
    }

    private void createEditPopup() {
        this.editTextField = new JTextField();
        Border border = UIManager.getBorder("List.focusCellHighlightBorder");
        this.editTextField.setBorder(border);
        this.editTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = EditListAction.this.editTextField.getText();
                ListModel model = EditListAction.this.list.getModel();
                int row = EditListAction.this.list.getSelectedIndex();
                EditListAction.this.applyValueToModel(value, model, row);
                EditListAction.this.editPopup.setVisible(false);
            }
        });
        this.editPopup = new JPopupMenu();
        this.editPopup.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.editPopup.add(this.editTextField);
    }
}

