/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class CompoundUndoManager
extends UndoManager
implements UndoableEditListener,
DocumentListener {
    private UndoManager undoManager;
    private CompoundEdit compoundEdit;
    private JTextComponent textComponent;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private int lastOffset;
    private int lastLength;

    public CompoundUndoManager(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.undoManager = this;
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        textComponent.getDocument().addUndoableEditListener(this);
    }

    @Override
    public void undo() {
        this.textComponent.getDocument().addDocumentListener(this);
        super.undo();
        this.textComponent.getDocument().removeDocumentListener(this);
    }

    @Override
    public void redo() {
        this.textComponent.getDocument().addDocumentListener(this);
        super.redo();
        this.textComponent.getDocument().removeDocumentListener(this);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.compoundEdit == null) {
            this.compoundEdit = this.startCompoundEdit(e.getEdit());
            return;
        }
        int offsetChange = this.textComponent.getCaretPosition() - this.lastOffset;
        int lengthChange = this.textComponent.getDocument().getLength() - this.lastLength;
        AbstractDocument.DefaultDocumentEvent event = (AbstractDocument.DefaultDocumentEvent)e.getEdit();
        if (event.getType().equals(DocumentEvent.EventType.CHANGE) && offsetChange == 0) {
            this.compoundEdit.addEdit(e.getEdit());
            return;
        }
        if (offsetChange == lengthChange && Math.abs(offsetChange) == 1) {
            this.compoundEdit.addEdit(e.getEdit());
            this.lastOffset = this.textComponent.getCaretPosition();
            this.lastLength = this.textComponent.getDocument().getLength();
            return;
        }
        this.compoundEdit.end();
        this.compoundEdit = this.startCompoundEdit(e.getEdit());
    }

    private CompoundEdit startCompoundEdit(UndoableEdit anEdit) {
        this.lastOffset = this.textComponent.getCaretPosition();
        this.lastLength = this.textComponent.getDocument().getLength();
        this.compoundEdit = new MyCompoundEdit();
        this.compoundEdit.addEdit(anEdit);
        this.addEdit(this.compoundEdit);
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
        return this.compoundEdit;
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    @Override
    public void insertUpdate(final DocumentEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int offset = e.getOffset() + e.getLength();
                offset = Math.min(offset, CompoundUndoManager.this.textComponent.getDocument().getLength());
                CompoundUndoManager.this.textComponent.setCaretPosition(offset);
            }
        });
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textComponent.setCaretPosition(e.getOffset());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            this.putValue("Name", "Redo");
            this.putValue("ShortDescription", this.getValue("Name"));
            this.putValue("MnemonicKey", new Integer(82));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 2));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                CompoundUndoManager.this.undoManager.redo();
                CompoundUndoManager.this.textComponent.requestFocusInWindow();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            this.updateRedoState();
            CompoundUndoManager.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            this.setEnabled(CompoundUndoManager.this.undoManager.canRedo());
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            this.putValue("Name", "Undo");
            this.putValue("ShortDescription", this.getValue("Name"));
            this.putValue("MnemonicKey", new Integer(85));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control Z"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                CompoundUndoManager.this.undoManager.undo();
                CompoundUndoManager.this.textComponent.requestFocusInWindow();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.updateUndoState();
            CompoundUndoManager.this.redoAction.updateRedoState();
        }

        private void updateUndoState() {
            this.setEnabled(CompoundUndoManager.this.undoManager.canUndo());
        }
    }

    class MyCompoundEdit
    extends CompoundEdit {
        MyCompoundEdit() {
        }

        @Override
        public boolean isInProgress() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (CompoundUndoManager.this.compoundEdit != null) {
                CompoundUndoManager.this.compoundEdit.end();
            }
            super.undo();
            CompoundUndoManager.this.compoundEdit = null;
        }
    }
}

