/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import com.wordpress.tipsforjava.swing.AnimatedIcon;
import javax.swing.Icon;
import javax.swing.JComponent;

public class CircularAnimatedIcon
extends AnimatedIcon {
    private int direction = 1;

    public CircularAnimatedIcon(JComponent component, Icon ... icons) {
        super(component, icons);
    }

    public CircularAnimatedIcon(JComponent component, int delay, Icon ... icons) {
        super(component, delay, icons);
    }

    public CircularAnimatedIcon(JComponent component, int delay, int cycles, Icon ... icons) {
        super(component, delay, cycles, icons);
    }

    @Override
    protected int getNextIconIndex(int currentIndex, int iconCount) {
        if (iconCount == 1) {
            return 0;
        }
        if ((currentIndex += this.direction) == iconCount) {
            currentIndex -= 2;
            this.direction = -1;
        }
        if (currentIndex == 0) {
            currentIndex = 0;
            this.direction = 1;
        }
        return currentIndex;
    }

    @Override
    protected boolean isCycleCompleted(int currentIndex, int iconCount) {
        return currentIndex == 0 && this.direction == 1;
    }
}

