/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;

public class CaretPositionListener
implements MouseListener {
    private boolean dynamicFormatting;

    public CaretPositionListener() {
    }

    public CaretPositionListener(JFormattedTextField ... components) {
        this.registerComponent(components);
    }

    public boolean isDynamicFormatting() {
        return this.dynamicFormatting;
    }

    public void setDynamicFormatting(boolean dynamicFormatting) {
        this.dynamicFormatting = dynamicFormatting;
    }

    public void deregisterComponent(JFormattedTextField ... components) {
        for (JFormattedTextField component : components) {
            component.removeMouseListener(this);
        }
    }

    public void registerComponent(JFormattedTextField ... components) {
        for (JFormattedTextField component : components) {
            component.addMouseListener(this);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        JFormattedTextField ftf = (JFormattedTextField)me.getSource();
        if (this.dynamicFormatting && ftf.getValue() != null) {
            this.determineCaretPosition(ftf);
        } else {
            int offset = ftf.getCaretPosition();
            this.setCaretPosition(ftf, offset);
        }
    }

    private void determineCaretPosition(JFormattedTextField ftf) {
        String value;
        int offset = ftf.getCaretPosition();
        String text = ftf.getText();
        if (text.equals(value = ftf.getValue().toString())) {
            this.setCaretPosition(ftf, offset);
            return;
        }
        int i = 0;
        int j = 0;
        while (j < offset) {
            if (text.charAt(i) == value.charAt(j)) {
                ++i;
                ++j;
                continue;
            }
            --offset;
            ++i;
        }
        this.setCaretPosition(ftf, offset);
    }

    private void setCaretPosition(final JFormattedTextField ftf, final int offset) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ftf.setCaretPosition(offset);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

