/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.tipsforjava.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.Timer;

public class AnimatedIcon
implements Icon,
ActionListener,
Runnable {
    private static final int DEFAULT_DELAY = 500;
    private static final int DEFAULT_CYCLES = -1;
    public static final float TOP = 0.0f;
    public static final float LEFT = 0.0f;
    public static final float CENTER = 0.5f;
    public static final float BOTTOM = 1.0f;
    public static final float RIGHT = 1.0f;
    private JComponent component;
    private List<Icon> icons = new ArrayList<Icon>();
    private int cycles;
    private boolean showFirstIcon = false;
    private float alignmentX = 0.5f;
    private float alignmentY = 0.5f;
    private int iconX;
    private int iconY;
    private int iconWidth;
    private int iconHeight;
    private int currentIconIndex;
    private int cyclesCompleted;
    private boolean animationFinished = true;
    private Timer timer;

    public AnimatedIcon(JComponent component, Icon ... icons) {
        this(component, 500, icons);
    }

    public AnimatedIcon(JComponent component, int delay, Icon ... icons) {
        this(component, delay, -1, icons);
    }

    public AnimatedIcon(JComponent component, int delay, int cycles, Icon ... icons) {
        this.component = component;
        this.setCycles(cycles);
        for (int i = 0; i < icons.length; ++i) {
            if (icons[i] == null) {
                String message = "Icon (" + i + ") cannot be null";
                throw new IllegalArgumentException(message);
            }
            this.addIcon(icons[i]);
        }
        this.timer = new Timer(delay, this);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void addIcon(Icon ... icons) {
        for (Icon icon : icons) {
            if (icon == null) continue;
            this.icons.add(icon);
            this.calculateIconDimensions();
        }
    }

    private void calculateIconDimensions() {
        this.iconWidth = 0;
        this.iconHeight = 0;
        for (Icon icon : this.icons) {
            this.iconWidth = Math.max(this.iconWidth, icon.getIconWidth());
            this.iconHeight = Math.max(this.iconHeight, icon.getIconHeight());
        }
    }

    public float getAlignmentX() {
        return this.alignmentX;
    }

    public void setAlignmentX(float alignmentX) {
        this.alignmentX = alignmentX > 1.0f ? 1.0f : (alignmentX < 0.0f ? 0.0f : alignmentX);
    }

    public float getAlignmentY() {
        return this.alignmentY;
    }

    public void setAlignmentY(float alignmentY) {
        this.alignmentY = alignmentY > 1.0f ? 1.0f : (alignmentY < 0.0f ? 0.0f : alignmentY);
    }

    public int getCurrentIconIndex() {
        return this.currentIconIndex;
    }

    public void setCurrentIconIndex(int index) {
        this.currentIconIndex = index;
        this.component.repaint(this.iconX, this.iconY, this.iconWidth, this.iconHeight);
    }

    public int getCycles() {
        return this.cycles;
    }

    public void setCycles(int cycles) {
        this.cycles = cycles;
    }

    public int getDelay() {
        return this.timer.getDelay();
    }

    public void setDelay(int delay) {
        this.timer.setDelay(delay);
    }

    public Icon getIcon(int index) {
        return this.icons.get(index);
    }

    public int getIconCount() {
        return this.icons.size();
    }

    public boolean isShowFirstIcon() {
        return this.showFirstIcon;
    }

    public void setShowFirstIcon(boolean showFirstIcon) {
        this.showFirstIcon = showFirstIcon;
    }

    public void pause() {
        this.timer.stop();
    }

    public void start() {
        if (!this.timer.isRunning()) {
            this.setCurrentIconIndex(0);
            this.animationFinished = false;
            this.cyclesCompleted = 0;
            this.timer.start();
        }
    }

    public void restart() {
        if (!this.timer.isRunning()) {
            if (this.animationFinished) {
                this.start();
            } else {
                this.timer.restart();
            }
        }
    }

    public void stop() {
        this.timer.stop();
        this.setCurrentIconIndex(0);
        this.animationFinished = true;
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (c == this.component) {
            this.iconX = x;
            this.iconY = y;
        }
        Icon icon = this.icons.get(this.currentIconIndex);
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        int offsetX = this.getOffset(width, icon.getIconWidth(), this.alignmentX);
        int offsetY = this.getOffset(height, icon.getIconHeight(), this.alignmentY);
        icon.paintIcon(c, g, x + offsetX, y + offsetY);
    }

    private int getOffset(int maxValue, int iconValue, float alignment) {
        float offset = (float)(maxValue - iconValue) * alignment;
        return Math.round(offset);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setCurrentIconIndex(this.getNextIconIndex(this.currentIconIndex, this.icons.size()));
        this.component.repaint(this.iconX, this.iconY, this.iconWidth, this.iconHeight);
        if (this.isCycleCompleted(this.currentIconIndex, this.icons.size())) {
            ++this.cyclesCompleted;
        }
        if (this.cycles > 0 && this.cycles <= this.cyclesCompleted) {
            this.timer.stop();
            this.animationFinished = true;
            if (this.isShowFirstIcon() && this.getCurrentIconIndex() != 0) {
                new Thread(this).start();
            }
        }
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.timer.getDelay());
            this.setCurrentIconIndex(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int getNextIconIndex(int currentIndex, int iconCount) {
        return ++currentIndex % iconCount;
    }

    protected boolean isCycleCompleted(int currentIndex, int iconCount) {
        return currentIndex == iconCount - 1;
    }
}

