/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.javafx;

import griffon.core.GriffonController;
import griffon.core.UIThreadManager;
import griffon.core.controller.GriffonControllerActionManager;
import griffon.util.GriffonNameUtils;
import groovyx.javafx.appsupport.Action;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import org.codehaus.griffon.runtime.core.controller.AbstractGriffonControllerAction;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class JavaFXGriffonControllerAction
extends AbstractGriffonControllerAction {
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_ICON = "icon";
    private final Action toolkitAction;

    public JavaFXGriffonControllerAction(final GriffonControllerActionManager actionManager, GriffonController controller, final String actionName) {
        super(actionManager, controller, actionName);
        final JavaFXGriffonControllerAction self = this;
        this.toolkitAction = new Action();
        this.toolkitAction.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                actionManager.invokeAction(self.getController(), actionName, new Object[]{actionEvent});
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent evt) {
                UIThreadManager.getInstance().executeAsync(new Runnable(){

                    @Override
                    public void run() {
                        String icon;
                        if ("name".equals(evt.getPropertyName())) {
                            JavaFXGriffonControllerAction.this.toolkitAction.setName(String.valueOf(evt.getNewValue()));
                        } else if ("shortDescription".equals(evt.getPropertyName()) || "longDescription".equals(evt.getPropertyName()) || JavaFXGriffonControllerAction.KEY_DESCRIPTION.equals(evt.getPropertyName())) {
                            JavaFXGriffonControllerAction.this.toolkitAction.setDescription(String.valueOf(evt.getNewValue()));
                        } else if ("enabled".equals(evt.getPropertyName())) {
                            JavaFXGriffonControllerAction.this.toolkitAction.setEnabled(DefaultTypeTransformation.castToBoolean((Object)evt.getNewValue()));
                        } else if ("selected".equals(evt.getPropertyName())) {
                            JavaFXGriffonControllerAction.this.toolkitAction.setSelected(DefaultTypeTransformation.castToBoolean((Object)evt.getNewValue()));
                        } else if ("accelerator".equals(evt.getPropertyName())) {
                            String accelerator = (String)evt.getNewValue();
                            if (!GriffonNameUtils.isBlank((String)accelerator)) {
                                JavaFXGriffonControllerAction.this.toolkitAction.setAccelerator(accelerator);
                            }
                        } else if (("smallIcon".equals(evt.getPropertyName()) || "largeIcon".equals(evt.getPropertyName()) || JavaFXGriffonControllerAction.KEY_ICON.equals(evt.getPropertyName())) && !GriffonNameUtils.isBlank((String)(icon = (String)evt.getNewValue()))) {
                            JavaFXGriffonControllerAction.this.toolkitAction.setIcon(icon);
                        }
                    }
                });
            }
        });
    }

    public Object getToolkitAction() {
        return this.toolkitAction;
    }

    protected void doExecute(Object ... args) {
        ActionEvent event = null;
        if (args != null && args.length == 1 && args[0] instanceof ActionEvent) {
            event = (ActionEvent)args[0];
        }
        ((EventHandler)this.toolkitAction.onActionProperty().get()).handle(event);
    }

    protected void doInitialize() {
        String icon;
        this.toolkitAction.setName(this.getName());
        String description = this.getShortDescription();
        if (GriffonNameUtils.isBlank((String)description)) {
            description = this.getLongDescription();
        }
        this.toolkitAction.setDescription(description);
        this.toolkitAction.setEnabled(this.isEnabled());
        this.toolkitAction.setSelected(this.isSelected());
        String accelerator = this.getAccelerator();
        if (!GriffonNameUtils.isBlank((String)accelerator)) {
            this.toolkitAction.setAccelerator(accelerator);
        }
        if (GriffonNameUtils.isBlank((String)(icon = this.getSmallIcon()))) {
            icon = this.getLargeIcon();
        }
        if (!GriffonNameUtils.isBlank((String)icon)) {
            this.toolkitAction.setIcon(icon);
        }
    }
}

