/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import java.util.List;
import java.util.Map;
import javafx.geometry.Rectangle2D;

public class Rectangle2DPropertyEditor
extends AbstractPropertyEditor {
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    public void setValue(Object value) {
        if (null == value) {
            return;
        }
        if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof Rectangle2D) {
            super.setValue(value);
        } else {
            throw this.illegalValue(value, Rectangle2D.class);
        }
    }

    private void handleAsString(String str) {
        String[] parts = str.split(",");
        switch (parts.length) {
            case 4: {
                double x = this.parseValue(parts[0]);
                double y = this.parseValue(parts[1]);
                double w = this.parseValue(parts[2]);
                double h = this.parseValue(parts[3]);
                super.setValue((Object)new Rectangle2D(x, y, w, h));
                break;
            }
            default: {
                throw this.illegalValue(str, Rectangle2D.class);
            }
        }
    }

    private void handleAsList(List list) {
        switch (list.size()) {
            case 4: {
                double x = this.parseValue(list.get(0));
                double y = this.parseValue(list.get(1));
                double w = this.parseValue(list.get(2));
                double h = this.parseValue(list.get(3));
                super.setValue((Object)new Rectangle2D(x, y, w, h));
                break;
            }
            default: {
                throw this.illegalValue(list, Rectangle2D.class);
            }
        }
    }

    private void handleAsMap(Map map) {
        double x = this.getMapValue(map, "x", 0.0);
        double y = this.getMapValue(map, "y", 0.0);
        double w = this.getMapValue(map, "width", 0.0);
        double h = this.getMapValue(map, "height", 0.0);
        super.setValue((Object)new Rectangle2D(x, y, w, h));
    }

    private double parseValue(Object value) {
        if (value instanceof CharSequence) {
            return this.parse(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.parse((Number)value);
        }
        throw this.illegalValue(value, Rectangle2D.class);
    }

    private double parse(String val) {
        try {
            return Double.parseDouble(val.trim());
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, Rectangle2D.class, e);
        }
    }

    private double parse(Number val) {
        return val.doubleValue();
    }

    private double getMapValue(Map map, String key, double defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            val = map.get(String.valueOf(key.charAt(0)));
        }
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return this.parse(String.valueOf(val));
        }
        if (val instanceof Number) {
            return this.parse((Number)val);
        }
        throw this.illegalValue(map, Rectangle2D.class);
    }
}

