/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import java.util.List;
import java.util.Map;
import javafx.geometry.Insets;

public class InsetsPropertyEditor
extends AbstractPropertyEditor {
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    public void setValue(Object value) {
        if (null == value) {
            return;
        }
        if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof Number) {
            this.handleAsNumber((Number)value);
        } else if (value instanceof Insets) {
            super.setValue(value);
        } else {
            throw this.illegalValue(value, Insets.class);
        }
    }

    private void handleAsString(String str) {
        double t = 0.0;
        double l = 0.0;
        double r = 0.0;
        double b = 0.0;
        String[] parts = str.split(",");
        switch (parts.length) {
            case 4: {
                b = this.parseValue(parts[3]);
            }
            case 3: {
                r = this.parseValue(parts[2]);
            }
            case 2: {
                l = this.parseValue(parts[1]);
            }
            case 1: {
                t = this.parseValue(parts[0]);
                super.setValue((Object)new Insets(t, l, r, b));
                break;
            }
            default: {
                throw this.illegalValue(str, Insets.class);
            }
        }
    }

    private void handleAsList(List list) {
        double t = 0.0;
        double l = 0.0;
        double r = 0.0;
        double b = 0.0;
        switch (list.size()) {
            case 4: {
                b = this.parseValue(list.get(3));
            }
            case 3: {
                r = this.parseValue(list.get(2));
            }
            case 2: {
                l = this.parseValue(list.get(1));
            }
            case 1: {
                t = this.parseValue(list.get(0));
                super.setValue((Object)new Insets(t, l, r, b));
                break;
            }
            default: {
                throw this.illegalValue(list, Insets.class);
            }
        }
    }

    private void handleAsMap(Map map) {
        double t = this.getMapValue(map, "top", 0.0);
        double l = this.getMapValue(map, "left", 0.0);
        double r = this.getMapValue(map, "right", 0.0);
        double b = this.getMapValue(map, "bottom", 0.0);
        super.setValue((Object)new Insets(t, l, r, b));
    }

    private double parseValue(Object value) {
        if (value instanceof CharSequence) {
            return this.parse(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.parse((Number)value);
        }
        throw this.illegalValue(value, Insets.class);
    }

    private double parse(String val) {
        try {
            return Double.parseDouble(String.valueOf(val).trim());
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, Insets.class, e);
        }
    }

    private double parse(Number val) {
        return val.doubleValue();
    }

    private double getMapValue(Map map, String key, double defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            val = map.get(String.valueOf(key.charAt(0)));
        }
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return this.parse(String.valueOf(val));
        }
        if (val instanceof Number) {
            return this.parse((Number)val);
        }
        throw this.illegalValue(map, Insets.class);
    }

    private void handleAsNumber(Number value) {
        double c = this.parse(value);
        super.setValue((Object)new Insets(c, c, c, c));
    }
}

