/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx;

import griffon.application.StandaloneGriffonApplication;
import griffon.core.UIThreadManager;
import griffon.javafx.ConfigurableWindowDisplayHandler;
import griffon.javafx.FXApplicationStub;
import griffon.javafx.JavaFXUIThreadHandler;
import griffon.javafx.WindowDisplayHandler;
import griffon.javafx.WindowManager;
import griffon.util.GriffonExceptionHandler;
import griffon.util.UIThreadHandler;
import javafx.application.Application;
import javafx.application.HostServices;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.codehaus.griffon.runtime.core.AbstractGriffonApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JavaFXApplication
extends AbstractGriffonApplication
implements StandaloneGriffonApplication {
    private static final Logger LOG = LoggerFactory.getLogger(JavaFXApplication.class);
    private boolean primaryStageDispensed = false;
    private final WindowManager windowManager;
    private WindowDisplayHandler windowDisplayHandler;
    private final WindowDisplayHandler defaultWindowDisplayHandler = new ConfigurableWindowDisplayHandler();
    private Application fxApp;
    private Stage primaryStage;
    final Object fxInitComplete = new Object();

    public JavaFXApplication() {
        this(AbstractGriffonApplication.EMPTY_ARGS);
    }

    public JavaFXApplication(String[] args) {
        super(args);
        this.windowManager = new WindowManager(this);
    }

    public HostServices getHostServices() {
        if (this.fxApp == null) {
            return null;
        }
        return this.fxApp.getHostServices();
    }

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }

    void setPrimaryStage(Stage primaryStage) {
        this.primaryStage = primaryStage;
    }

    void setFXApp(Application fxApp) {
        this.fxApp = fxApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap() {
        FXApplicationStub.setGriffonApp(this);
        Object object = this.fxInitComplete;
        synchronized (object) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Application.launch(FXApplicationStub.class, (String[])JavaFXApplication.this.getStartupArgs());
                }
            }).start();
            try {
                this.fxInitComplete.wait();
                this.doGriffonInit();
            }
            catch (InterruptedException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Interrupted while waiting for JavaFX initialization: " + e.getMessage());
                }
                GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
            }
        }
    }

    public void realize() {
        this.startup();
    }

    public void show() {
        Window startingWindow = this.windowManager.getStartingWindow();
        this.windowManager.show(startingWindow);
        this.ready();
    }

    public Object createApplicationContainer() {
        if (this.primaryStageDispensed) {
            return new Stage();
        }
        this.primaryStageDispensed = true;
        return this.primaryStage;
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public WindowDisplayHandler getWindowDisplayHandler() {
        return this.windowDisplayHandler;
    }

    public void setWindowDisplayHandler(WindowDisplayHandler windowDisplayHandler) {
        this.windowDisplayHandler = windowDisplayHandler;
    }

    public final WindowDisplayHandler resolveWindowDisplayHandler() {
        return this.windowDisplayHandler != null ? this.windowDisplayHandler : this.defaultWindowDisplayHandler;
    }

    private void doGriffonInit() {
        UIThreadManager.getInstance().setUIThreadHandler((UIThreadHandler)new JavaFXUIThreadHandler());
        this.addShutdownHandler(this.windowManager);
        this.initialize();
    }

    public static void main(String[] args) {
        GriffonExceptionHandler.registerExceptionHandler();
        JavaFXApplication app = new JavaFXApplication(args);
        try {
            app.bootstrap();
            app.realize();
            app.show();
        }
        catch (RuntimeException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
    }
}

