/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx;

import griffon.application.StandaloneGriffonApplication;
import griffon.core.UIThreadManager;
import griffon.javafx.FXApplicationStub;
import griffon.javafx.JavaFXUIThreadHandler;
import griffon.util.GriffonExceptionHandler;
import griffon.util.UIThreadHandler;
import javafx.application.Application;
import javafx.application.HostServices;
import javafx.stage.Stage;
import org.codehaus.griffon.runtime.core.AbstractGriffonApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JavaFXApplication
extends AbstractGriffonApplication
implements StandaloneGriffonApplication {
    private static final Logger LOG = LoggerFactory.getLogger(JavaFXApplication.class);
    private Application fxApp;
    private Stage primaryStage;
    final Object fxInitComplete = new Object();

    public JavaFXApplication() {
        this(AbstractGriffonApplication.EMPTY_ARGS);
    }

    public JavaFXApplication(String[] args) {
        super(args);
    }

    public HostServices getHostServices() {
        if (this.fxApp == null) {
            return null;
        }
        return this.fxApp.getHostServices();
    }

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }

    void setPrimaryStage(Stage primaryStage) {
        this.primaryStage = primaryStage;
    }

    void setFXApp(Application fxApp) {
        this.fxApp = fxApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap() {
        FXApplicationStub.setGriffonApp(this);
        Object object = this.fxInitComplete;
        synchronized (object) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Application.launch(FXApplicationStub.class, (String[])JavaFXApplication.this.getStartupArgs());
                }
            }).start();
            try {
                this.fxInitComplete.wait();
                this.doGriffonInit();
            }
            catch (InterruptedException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Interrupted while waiting for JavaFX initialization: " + e.getMessage());
                }
                GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
            }
        }
    }

    public void realize() {
        this.startup();
    }

    public void show() {
        this.ready();
    }

    public Object createApplicationContainer() {
        return this.primaryStage;
    }

    private void doGriffonInit() {
        UIThreadManager.getInstance().setUIThreadHandler((UIThreadHandler)new JavaFXUIThreadHandler());
        this.initialize();
    }

    public static void main(String[] args) {
        GriffonExceptionHandler.registerExceptionHandler();
        JavaFXApplication app = new JavaFXApplication(args);
        try {
            app.bootstrap();
            app.realize();
            app.show();
        }
        catch (RuntimeException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
    }
}

