/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javafx.scene.image.Image;

public class ImagePropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof File) {
            this.handleAsFile((File)value);
        } else if (value instanceof URL) {
            this.handleAsURL((URL)value);
        } else if (value instanceof URI) {
            this.handleAsURI((URI)value);
        } else if (value instanceof InputStream) {
            this.handleAsInputStream((InputStream)value);
        } else if (value instanceof Image) {
            super.setValueInternal(value);
        } else {
            throw this.illegalValue(value, Image.class);
        }
    }

    private void handleAsString(String str) {
        this.handleAsURL(((Object)((Object)this)).getClass().getClassLoader().getResource(str));
    }

    private void handleAsFile(File file) {
        try {
            this.handleAsURL(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw this.illegalValue(file, URL.class);
        }
    }

    private void handleAsURL(URL url) {
        try {
            super.setValueInternal((Object)new Image(url.toString()));
        }
        catch (Exception e) {
            throw this.illegalValue(url, URL.class);
        }
    }

    private void handleAsURI(URI uri) {
        try {
            this.handleAsURL(uri.toURL());
        }
        catch (MalformedURLException e) {
            throw this.illegalValue(uri, URL.class);
        }
    }

    private void handleAsInputStream(InputStream stream) {
        try {
            super.setValueInternal((Object)new Image(stream));
        }
        catch (Exception e) {
            throw this.illegalValue(stream, URL.class);
        }
    }
}

