/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx;

import griffon.core.AddonManager;
import griffon.core.ApplicationPhase;
import griffon.core.ArtifactManager;
import griffon.core.Event;
import griffon.core.EventRouter;
import griffon.core.GriffonApplication;
import griffon.core.GriffonController;
import griffon.core.GriffonModel;
import griffon.core.GriffonMvcArtifact;
import griffon.core.GriffonService;
import griffon.core.GriffonView;
import griffon.core.MVCClosure;
import griffon.core.MVCGroup;
import griffon.core.MVCGroupManager;
import griffon.core.ServiceManager;
import griffon.core.ShutdownHandler;
import griffon.core.UIThreadManager;
import griffon.core.controller.GriffonControllerActionManager;
import griffon.core.i18n.MessageSource;
import griffon.core.i18n.NoSuchMessageException;
import griffon.core.resources.NoSuchResourceException;
import griffon.core.resources.ResourceResolver;
import griffon.exceptions.GriffonException;
import griffon.util.ApplicationClassLoader;
import griffon.util.ApplicationHolder;
import griffon.util.ConfigUtils;
import griffon.util.Metadata;
import griffon.util.RunnableWithArgs;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.util.ConfigObject;
import groovy.util.FactoryBuilderSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.codehaus.griffon.runtime.core.NoopEventRouter;
import org.codehaus.griffon.runtime.core.ResourceLocator;
import org.codehaus.griffon.runtime.util.ExecutorServiceHolder;
import org.codehaus.griffon.runtime.util.GriffonApplicationHelper;
import org.codehaus.griffon.runtime.util.MVCGroupExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaFXGriffonApplication
extends Application
implements GriffonApplication {
    private Binding bindings = new Binding();
    private ConfigObject config;
    private ConfigObject builderConfig;
    private Object eventsConfig;
    private AddonManager addonManager;
    private ArtifactManager artifactManager;
    private MVCGroupManager mvcGroupManager;
    private ServiceManager serviceManager;
    private MessageSource messageSource;
    private ResourceResolver resourceResolver;
    private GriffonControllerActionManager actionManager;
    private Locale locale = Locale.getDefault();
    public static final String[] EMPTY_ARGS = new String[0];
    protected final Object[] lock = new Object[0];
    private ApplicationPhase phase = ApplicationPhase.INITIALIZE;
    private EventRouter eventRouter = new NoopEventRouter();
    private final ResourceLocator resourceLocator = new ResourceLocator();
    private final List<ShutdownHandler> shutdownHandlers = new ArrayList<ShutdownHandler>();
    private String[] startupArgs;
    private final Object shutdownLock = new Object();
    private final Logger log;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);

    public AbstractJavaFXGriffonApplication() {
        this(EMPTY_ARGS);
    }

    public AbstractJavaFXGriffonApplication(String[] args) {
        this.startupArgs = new String[args.length];
        System.arraycopy(args, 0, this.startupArgs, 0, args.length);
        ApplicationHolder.setApplication((GriffonApplication)this);
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        MVCGroupExceptionHandler.registerWith((GriffonApplication)this);
    }

    public void start(Stage stage) throws Exception {
        stage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent t) {
                AbstractJavaFXGriffonApplication.this.shutdown();
            }
        });
    }

    public void stop() throws Exception {
        this.shutdown();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        this.pcs.firePropertyChange(event);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public EventRouter getEventRouter() {
        return this.eventRouter;
    }

    public void setEventRouter(EventRouter eventRouter) {
        this.eventRouter = eventRouter;
    }

    public Binding getBindings() {
        return this.bindings;
    }

    public void setBindings(Binding bindings) {
        this.bindings = bindings;
    }

    public ConfigObject getConfig() {
        return this.config;
    }

    public void setConfig(ConfigObject config) {
        this.config = config;
    }

    public ConfigObject getBuilderConfig() {
        return this.builderConfig;
    }

    public void setBuilderConfig(ConfigObject builderConfig) {
        this.builderConfig = builderConfig;
    }

    public Object getEventsConfig() {
        return this.eventsConfig;
    }

    public void setEventsConfig(Object eventsConfig) {
        this.eventsConfig = eventsConfig;
    }

    public Map<String, ? extends GriffonModel> getModels() {
        return this.getMvcGroupManager().getModels();
    }

    public Map<String, ? extends GriffonView> getViews() {
        return this.getMvcGroupManager().getViews();
    }

    public Map<String, ? extends GriffonController> getControllers() {
        return this.getMvcGroupManager().getControllers();
    }

    public Map<String, ? extends FactoryBuilderSupport> getBuilders() {
        return this.getMvcGroupManager().getBuilders();
    }

    public Map<String, MVCGroup> getGroups() {
        return this.getMvcGroupManager().getGroups();
    }

    public AddonManager getAddonManager() {
        return this.addonManager;
    }

    public void setAddonManager(AddonManager addonManager) {
        this.addonManager = addonManager;
    }

    public ArtifactManager getArtifactManager() {
        return this.artifactManager;
    }

    public void setArtifactManager(ArtifactManager artifactManager) {
        this.artifactManager = artifactManager;
    }

    public MVCGroupManager getMvcGroupManager() {
        return this.mvcGroupManager;
    }

    public void setMvcGroupManager(MVCGroupManager mvcGroupManager) {
        this.mvcGroupManager = mvcGroupManager;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public Map<String, ? extends GriffonService> getServices() {
        return this.serviceManager.getServices();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String[] getStartupArgs() {
        return this.startupArgs;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLocaleAsString(String locale) {
        this.setLocale(GriffonApplicationHelper.parseLocale((String)locale));
    }

    public void setLocale(Locale locale) {
        Locale oldValue = this.locale;
        this.locale = locale;
        Locale.setDefault(locale);
        this.firePropertyChange("locale", oldValue, locale);
    }

    public Metadata getMetadata() {
        return Metadata.getCurrent();
    }

    public Class getAppConfigClass() {
        return this.loadConfigurationalClass(GriffonApplication.Configuration.APPLICATION.getName());
    }

    public Class getConfigClass() {
        return this.loadConfigurationalClass(GriffonApplication.Configuration.CONFIG.getName());
    }

    public Class getBuilderClass() {
        return this.loadConfigurationalClass(GriffonApplication.Configuration.BUILDER.getName());
    }

    public Class getEventsClass() {
        return this.loadConfigurationalClass(GriffonApplication.Configuration.EVENTS.getName());
    }

    public void initialize() {
        if (this.getPhase() == ApplicationPhase.INITIALIZE) {
            Application.Parameters parameters = this.getParameters();
            if (parameters != null && parameters.getRaw().size() > 0) {
                int length = parameters.getRaw().size();
                this.startupArgs = new String[length];
                System.arraycopy(parameters.getRaw().toArray(), 0, this.startupArgs, 0, length);
            }
            GriffonApplicationHelper.prepare((GriffonApplication)this);
        }
    }

    public void ready() {
        if (this.getPhase() != ApplicationPhase.STARTUP) {
            return;
        }
        this.setPhase(ApplicationPhase.READY);
        this.event(GriffonApplication.Event.READY_START.getName(), Arrays.asList(this));
        GriffonApplicationHelper.runLifecycleHandler((String)GriffonApplication.Lifecycle.READY.getName(), (GriffonApplication)this);
        this.event(GriffonApplication.Event.READY_END.getName(), Arrays.asList(this));
        this.setPhase(ApplicationPhase.MAIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canShutdown() {
        this.event(GriffonApplication.Event.SHUTDOWN_REQUESTED.getName(), Arrays.asList(this));
        Object object = this.shutdownLock;
        synchronized (object) {
            for (ShutdownHandler handler : this.shutdownHandlers) {
                if (handler.canShutdown((GriffonApplication)this)) continue;
                this.event(GriffonApplication.Event.SHUTDOWN_ABORTED.getName(), Arrays.asList(this));
                if (this.log.isDebugEnabled()) {
                    try {
                        this.log.debug("Shutdown aborted by " + handler);
                    }
                    catch (UnsupportedOperationException uoe) {
                        this.log.debug("Shutdown aborted by a handler");
                    }
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        Object latch;
        if (this.getPhase() == ApplicationPhase.SHUTDOWN) {
            return false;
        }
        if (!this.canShutdown()) {
            return false;
        }
        this.log.info("Shutdown is in process");
        this.setPhase(ApplicationPhase.SHUTDOWN);
        this.log.debug("Shutdown stage 1: notify all event listeners");
        if (this.isEventPublishingEnabled()) {
            latch = new CountDownLatch(this.isUIThread() ? 1 : 0);
            this.addApplicationEventListener(GriffonApplication.Event.SHUTDOWN_START.getName(), new RunnableWithArgs((CountDownLatch)latch){
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$latch = countDownLatch;
                }

                public void run(Object[] args) {
                    this.val$latch.countDown();
                }
            });
            this.event(GriffonApplication.Event.SHUTDOWN_START.getName(), Arrays.asList(this));
            try {
                ((CountDownLatch)latch).await();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.log.debug("Shutdown stage 2: notify all shutdown handlers");
        latch = this.shutdownLock;
        synchronized (latch) {
            for (ShutdownHandler handler : this.shutdownHandlers) {
                handler.onShutdown((GriffonApplication)this);
            }
        }
        this.log.debug("Shutdown stage 3: destroy all MVC groups");
        ArrayList mvcNames = new ArrayList();
        if (this.getMvcGroupManager() != null) {
            mvcNames.addAll(this.getMvcGroupManager().getGroups().keySet());
            for (String name : mvcNames) {
                this.destroyMVCGroup(name);
            }
        }
        this.log.debug("Shutdown stage 4: execute Shutdown script");
        GriffonApplicationHelper.runLifecycleHandler((String)GriffonApplication.Lifecycle.SHUTDOWN.getName(), (GriffonApplication)this);
        ExecutorServiceHolder.shutdownAll();
        return true;
    }

    public void startup() {
        if (this.getPhase() != ApplicationPhase.INITIALIZE) {
            return;
        }
        this.setPhase(ApplicationPhase.STARTUP);
        this.event(GriffonApplication.Event.STARTUP_START.getName(), Arrays.asList(this));
        Object startupGroups = ConfigUtils.getConfigValue((Map)this.getConfig(), (String)"application.startupGroups");
        if (startupGroups instanceof List) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Initializing all startup groups: " + startupGroups);
            }
            for (String groupName : (List)startupGroups) {
                this.createMVCGroup(groupName);
            }
        } else if (startupGroups != null && startupGroups.getClass().isArray()) {
            Object[] groups = (Object[])startupGroups;
            if (this.log.isInfoEnabled()) {
                this.log.info("Initializing all startup groups: " + Arrays.toString(groups));
            }
            for (Object groupName : groups) {
                this.createMVCGroup(String.valueOf(groupName));
            }
        }
        GriffonApplicationHelper.runLifecycleHandler((String)GriffonApplication.Lifecycle.STARTUP.getName(), (GriffonApplication)this);
        this.event(GriffonApplication.Event.STARTUP_END.getName(), Arrays.asList(this));
    }

    public void event(String eventName) {
        this.eventRouter.publish(eventName, Collections.emptyList());
    }

    public void event(String eventName, List params) {
        this.eventRouter.publish(eventName, params);
    }

    public void eventOutsideUI(String eventName) {
        this.eventRouter.publishOutsideUI(eventName, Collections.emptyList());
    }

    public void eventOutsideUI(String eventName, List params) {
        this.eventRouter.publishOutsideUI(eventName, params);
    }

    public void eventAsync(String eventName) {
        this.eventRouter.publishAsync(eventName, Collections.emptyList());
    }

    public void eventAsync(String eventName, List params) {
        this.eventRouter.publishAsync(eventName, params);
    }

    public void addApplicationEventListener(Object listener) {
        this.eventRouter.addEventListener(listener);
    }

    public void removeApplicationEventListener(Object listener) {
        this.eventRouter.removeEventListener(listener);
    }

    public void addApplicationEventListener(String eventName, Closure listener) {
        this.eventRouter.addEventListener(eventName, listener);
    }

    public void removeApplicationEventListener(String eventName, Closure listener) {
        this.eventRouter.removeEventListener(eventName, listener);
    }

    public void addApplicationEventListener(String eventName, RunnableWithArgs listener) {
        this.eventRouter.addEventListener(eventName, listener);
    }

    public void removeApplicationEventListener(String eventName, RunnableWithArgs listener) {
        this.eventRouter.removeEventListener(eventName, listener);
    }

    public void eventOutsideUI(Event event) {
        this.eventRouter.publishOutsideUI(event);
    }

    public void eventAsync(Event event) {
        this.eventRouter.publishAsync(event);
    }

    public void event(Event event) {
        this.eventRouter.publish(event);
    }

    public void addApplicationEventListener(Class<? extends Event> eventClass, Closure listener) {
        this.eventRouter.addEventListener(eventClass, listener);
    }

    public void addApplicationEventListener(Class<? extends Event> eventClass, RunnableWithArgs listener) {
        this.eventRouter.addEventListener(eventClass, listener);
    }

    public void removeApplicationEventListener(Class<? extends Event> eventClass, Closure listener) {
        this.eventRouter.removeEventListener(eventClass, listener);
    }

    public void removeApplicationEventListener(Class<? extends Event> eventClass, RunnableWithArgs listener) {
        this.eventRouter.removeEventListener(eventClass, listener);
    }

    public boolean isEventPublishingEnabled() {
        return this.eventRouter.isEnabled();
    }

    public void setEventPublishingEnabled(boolean enabled) {
        this.eventRouter.setEnabled(enabled);
    }

    public Object createApplicationContainer() {
        return null;
    }

    public void addShutdownHandler(ShutdownHandler handler) {
        if (handler != null && !this.shutdownHandlers.contains(handler)) {
            this.shutdownHandlers.add(handler);
        }
    }

    public void removeShutdownHandler(ShutdownHandler handler) {
        if (handler != null) {
            this.shutdownHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationPhase getPhase() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.phase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPhase(ApplicationPhase phase) {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            this.phase = phase;
            this.firePropertyChange("phase", this.phase, this.phase);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean isUIThread() {
        return UIThreadManager.getInstance().isUIThread();
    }

    public void execInsideUIAsync(Runnable runnable) {
        UIThreadManager.getInstance().executeAsync(runnable);
    }

    public void execInsideUISync(Runnable runnable) {
        UIThreadManager.getInstance().executeSync(runnable);
    }

    public void execOutsideUI(Runnable runnable) {
        UIThreadManager.getInstance().executeOutside(runnable);
    }

    public <R> Future<R> execFuture(ExecutorService executorService, Closure<R> closure) {
        return UIThreadManager.getInstance().executeFuture(executorService, closure);
    }

    public <R> Future<R> execFuture(Closure<R> closure) {
        return UIThreadManager.getInstance().executeFuture(closure);
    }

    public <R> Future<R> execFuture(ExecutorService executorService, Callable<R> callable) {
        return UIThreadManager.getInstance().executeFuture(executorService, callable);
    }

    public <R> Future<R> execFuture(Callable<R> callable) {
        return UIThreadManager.getInstance().executeFuture(callable);
    }

    public Object newInstance(Class clazz, String type) {
        return GriffonApplicationHelper.newInstance((GriffonApplication)this, (Class)clazz, (String)type);
    }

    public MVCGroup buildMVCGroup(String mvcType) {
        return this.getMvcGroupManager().buildMVCGroup(mvcType, null, Collections.emptyMap());
    }

    public MVCGroup buildMVCGroup(String mvcType, String mvcName) {
        return this.getMvcGroupManager().buildMVCGroup(mvcType, mvcName, Collections.emptyMap());
    }

    public MVCGroup buildMVCGroup(Map<String, Object> args, String mvcType) {
        return this.getMvcGroupManager().buildMVCGroup(mvcType, null, args);
    }

    public MVCGroup buildMVCGroup(String mvcType, Map<String, Object> args) {
        return this.getMvcGroupManager().buildMVCGroup(mvcType, null, args);
    }

    public MVCGroup buildMVCGroup(Map<String, Object> args, String mvcType, String mvcName) {
        return this.getMvcGroupManager().buildMVCGroup(mvcType, mvcName, args);
    }

    public MVCGroup buildMVCGroup(String mvcType, String mvcName, Map<String, Object> args) {
        return this.getMvcGroupManager().buildMVCGroup(mvcType, mvcName, args);
    }

    public List<? extends GriffonMvcArtifact> createMVCGroup(String mvcType) {
        return this.getMvcGroupManager().createMVCGroup(mvcType, null, Collections.emptyMap());
    }

    public List<? extends GriffonMvcArtifact> createMVCGroup(Map<String, Object> args, String mvcType) {
        return this.getMvcGroupManager().createMVCGroup(mvcType, null, args);
    }

    public List<? extends GriffonMvcArtifact> createMVCGroup(String mvcType, Map<String, Object> args) {
        return this.getMvcGroupManager().createMVCGroup(mvcType, null, args);
    }

    public List<? extends GriffonMvcArtifact> createMVCGroup(String mvcType, String mvcName) {
        return this.getMvcGroupManager().createMVCGroup(mvcType, mvcName, Collections.emptyMap());
    }

    public List<? extends GriffonMvcArtifact> createMVCGroup(Map<String, Object> args, String mvcType, String mvcName) {
        return this.getMvcGroupManager().createMVCGroup(mvcType, mvcName, args);
    }

    public List<? extends GriffonMvcArtifact> createMVCGroup(String mvcType, String mvcName, Map<String, Object> args) {
        return this.getMvcGroupManager().createMVCGroup(mvcType, mvcName, args);
    }

    public void destroyMVCGroup(String mvcName) {
        this.getMvcGroupManager().destroyMVCGroup(mvcName);
    }

    public void withMVCGroup(String mvcType, Closure handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, null, Collections.emptyMap(), handler);
    }

    public void withMVCGroup(String mvcType, String mvcName, Closure handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, mvcName, Collections.emptyMap(), handler);
    }

    public void withMVCGroup(String mvcType, Map<String, Object> args, Closure handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, null, args, handler);
    }

    public void withMVCGroup(Map<String, Object> args, String mvcType, Closure handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, null, args, handler);
    }

    public void withMVCGroup(String mvcType, String mvcName, Map<String, Object> args, Closure handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, mvcName, args, handler);
    }

    public void withMVCGroup(Map<String, Object> args, String mvcType, String mvcName, Closure handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, mvcName, args, handler);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(String mvcType, MVCClosure<M, V, C> handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, null, Collections.emptyMap(), handler);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(String mvcType, String mvcName, MVCClosure<M, V, C> handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, mvcName, Collections.emptyMap(), handler);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(String mvcType, Map<String, Object> args, MVCClosure<M, V, C> handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, null, args, handler);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(Map<String, Object> args, String mvcType, MVCClosure<M, V, C> handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, null, args, handler);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(String mvcType, String mvcName, Map<String, Object> args, MVCClosure<M, V, C> handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, mvcName, args, handler);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(Map<String, Object> args, String mvcType, String mvcName, MVCClosure<M, V, C> handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, mvcName, args, handler);
    }

    private Class<?> loadClass(String className) {
        try {
            return ApplicationClassLoader.get().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private Class<?> loadConfigurationalClass(String className) {
        if (!className.contains(".")) {
            String fixedClassName = "config." + className;
            try {
                return ApplicationClassLoader.get().loadClass(fixedClassName);
            }
            catch (ClassNotFoundException cnfe) {
                if (cnfe.getMessage().equals(fixedClassName)) {
                    return this.loadClass(className);
                }
                throw new GriffonException((Throwable)cnfe);
            }
        }
        return this.loadClass(className);
    }

    public InputStream getResourceAsStream(String name) {
        return this.resourceLocator.getResourceAsStream(name);
    }

    public URL getResourceAsURL(String name) {
        return this.resourceLocator.getResourceAsURL(name);
    }

    public List<URL> getResources(String name) {
        return this.resourceLocator.getResources(name);
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String getMessage(String key) throws NoSuchMessageException {
        return this.messageSource.getMessage(key);
    }

    public String getMessage(String key, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(key, locale);
    }

    public String getMessage(String key, Object[] args) throws NoSuchMessageException {
        return this.messageSource.getMessage(key, args);
    }

    public String getMessage(String key, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(key, args, locale);
    }

    public String getMessage(String key, List args) throws NoSuchMessageException {
        return this.messageSource.getMessage(key, args);
    }

    public String getMessage(String key, List args, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(key, args, locale);
    }

    public String getMessage(String key, String defaultMessage) {
        return this.messageSource.getMessage(key, defaultMessage);
    }

    public String getMessage(String key, String defaultMessage, Locale locale) {
        return this.messageSource.getMessage(key, defaultMessage, locale);
    }

    public String getMessage(String key, Object[] args, String defaultMessage) {
        return this.messageSource.getMessage(key, args, defaultMessage);
    }

    public String getMessage(String key, Object[] args, String defaultMessage, Locale locale) {
        return this.messageSource.getMessage(key, args, defaultMessage, locale);
    }

    public String getMessage(String key, List args, String defaultMessage) {
        return this.messageSource.getMessage(key, args, defaultMessage);
    }

    public String getMessage(String key, List args, String defaultMessage, Locale locale) {
        return this.messageSource.getMessage(key, args, defaultMessage, locale);
    }

    public String getMessage(String key, Map<String, Object> args) throws NoSuchMessageException {
        return this.messageSource.getMessage(key, args);
    }

    public String getMessage(String key, Map<String, Object> args, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(key, args, locale);
    }

    public String getMessage(String key, Map<String, Object> args, String defaultMessage) {
        return this.messageSource.getMessage(key, args, defaultMessage);
    }

    public String getMessage(String key, Map<String, Object> args, String defaultMessage, Locale locale) {
        return this.messageSource.getMessage(key, args, defaultMessage, locale);
    }

    public Object resolveMessageValue(String key, Locale locale) throws NoSuchMessageException {
        return this.messageSource.resolveMessageValue(key, locale);
    }

    public String formatMessage(String message, Map<String, Object> args) {
        return this.messageSource.formatMessage(message, args);
    }

    public String formatMessage(String message, List args) {
        return this.messageSource.formatMessage(message, args);
    }

    public String formatMessage(String message, Object[] args) {
        return this.messageSource.formatMessage(message, args);
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public Object resolveResource(String key) throws NoSuchResourceException {
        return this.resourceResolver.resolveResource(key);
    }

    public Object resolveResource(String key, Locale locale) throws NoSuchResourceException {
        return this.resourceResolver.resolveResource(key, locale);
    }

    public Object resolveResource(String key, Object[] args) throws NoSuchResourceException {
        return this.resourceResolver.resolveResource(key, args);
    }

    public Object resolveResource(String key, Object[] args, Locale locale) throws NoSuchResourceException {
        return this.resourceResolver.resolveResource(key, args, locale);
    }

    public Object resolveResource(String key, List args) throws NoSuchResourceException {
        return this.resourceResolver.resolveResource(key, args);
    }

    public Object resolveResource(String key, List args, Locale locale) throws NoSuchResourceException {
        return this.resourceResolver.resolveResource(key, args, locale);
    }

    public Object resolveResource(String key, Object defaultValue) {
        return this.resourceResolver.resolveResource(key, defaultValue);
    }

    public Object resolveResource(String key, Object defaultValue, Locale locale) {
        return this.resourceResolver.resolveResource(key, defaultValue, locale);
    }

    public Object resolveResource(String key, Object[] args, Object defaultValue) {
        return this.resourceResolver.resolveResource(key, args, defaultValue);
    }

    public Object resolveResource(String key, Object[] args, Object defaultValue, Locale locale) {
        return this.resourceResolver.resolveResource(key, args, defaultValue, locale);
    }

    public Object resolveResource(String key, List args, Object defaultValue) {
        return this.resourceResolver.resolveResource(key, args, defaultValue);
    }

    public Object resolveResource(String key, List args, Object defaultValue, Locale locale) {
        return this.resourceResolver.resolveResource(key, args, defaultValue, locale);
    }

    public Object resolveResource(String key, Map<String, Object> args) throws NoSuchResourceException {
        return this.resourceResolver.resolveResource(key, args);
    }

    public Object resolveResource(String key, Map<String, Object> args, Locale locale) throws NoSuchResourceException {
        return this.resourceResolver.resolveResource(key, args, locale);
    }

    public Object resolveResource(String key, Map<String, Object> args, Object defaultValue) {
        return this.resourceResolver.resolveResource(key, args, defaultValue);
    }

    public Object resolveResource(String key, Map<String, Object> args, Object defaultValue, Locale locale) {
        return this.resourceResolver.resolveResource(key, args, defaultValue, locale);
    }

    public Object resolveResourceValue(String key, Locale locale) throws NoSuchResourceException {
        return this.resourceResolver.resolveResourceValue(key, locale);
    }

    public String formatResource(String resource, List args) {
        return this.resourceResolver.formatResource(resource, args);
    }

    public String formatResource(String resource, Object[] args) {
        return this.resourceResolver.formatResource(resource, args);
    }

    public String formatResource(String resource, Map<String, Object> args) {
        return this.resourceResolver.formatResource(resource, args);
    }

    public GriffonControllerActionManager getActionManager() {
        return this.actionManager;
    }

    public void setActionManager(GriffonControllerActionManager actionManager) {
        this.actionManager = actionManager;
    }
}

