/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx;

import griffon.core.ApplicationPhase;
import griffon.core.GriffonApplication;
import griffon.core.ShutdownHandler;
import griffon.javafx.JavaFXGriffonApplication;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import groovy.util.ConfigObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.event.EventHandler;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WindowManager
implements ShutdownHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WindowManager.class);
    private final JavaFXGriffonApplication app;
    private final OnWindowHidingHelper onWindowHiding = new OnWindowHidingHelper();
    private final OnWindowShownHelper onWindowShown = new OnWindowShownHelper();
    private final OnWindowHiddenHelper onWindowHidden = new OnWindowHiddenHelper();
    private final Map<String, Window> windows = new ConcurrentHashMap<String, Window>();

    public WindowManager(JavaFXGriffonApplication app) {
        this.app = app;
    }

    public Window findWindow(String name) {
        if (!GriffonNameUtils.isBlank((String)name)) {
            return this.windows.get(name);
        }
        return null;
    }

    public String findWindowName(Window window) {
        if (window != null) {
            for (Map.Entry<String, Window> entry : this.windows.entrySet()) {
                if (entry.getValue() != window) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public Window getStartingWindow() {
        int index;
        Window window = null;
        Object value = ConfigUtils.getConfigValue((Map)this.app.getConfig(), (String)"javafx.windowManager.startingWindow");
        if (LOG.isDebugEnabled()) {
            LOG.debug("javafx.windowManager.startingWindow configured to " + value);
        }
        if (value == null || value instanceof ConfigObject) {
            if (this.windows.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No startingWindow configured, selecting the first one in the list of windows");
                }
                window = this.windows.values().iterator().next();
            }
        } else if (value instanceof String) {
            String windowName = (String)value;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selecting window " + windowName + " as starting window");
            }
            window = this.findWindow(windowName);
        } else if (value instanceof Number && (index = ((Number)value).intValue()) >= 0 && index < this.windows.size()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selecting window at index " + index + " as starting window");
            }
            int i = 0;
            Iterator<Window> iter = this.windows.values().iterator();
            while (iter.hasNext()) {
                if (i == index) {
                    window = iter.next();
                    break;
                }
                ++i;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting window is " + window);
        }
        return window;
    }

    public Collection<Window> getWindows() {
        return Collections.unmodifiableCollection(this.windows.values());
    }

    public void attach(String name, Window window) {
        if (window == null || this.windows.values().contains(window)) {
            return;
        }
        window.setOnHiding((EventHandler)this.onWindowHiding);
        window.setOnShown((EventHandler)this.onWindowShown);
        window.setOnHidden((EventHandler)this.onWindowHidden);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attaching window with name: '" + name + " " + window);
        }
        this.windows.put(name, window);
    }

    public void detach(Window window) {
        if (window == null) {
            return;
        }
        if (this.windows.values().contains(window)) {
            window.setOnHiding(null);
            window.setOnShown(null);
            window.setOnHidden(null);
            String name = this.findWindowName(window);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detaching window with name: '" + name + " " + window);
            }
            this.windows.remove(name);
        }
    }

    public void show(final Window window) {
        if (window == null) {
            return;
        }
        this.app.execInsideUISync(new Runnable(){

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Showing window with name: '" + WindowManager.this.findWindowName(window) + " " + window);
                }
                WindowManager.this.app.resolveWindowDisplayHandler().show(window, WindowManager.this.app);
            }
        });
    }

    public void hide(final Window window) {
        if (window == null) {
            return;
        }
        this.app.execInsideUISync(new Runnable(){

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Hiding window with name: '" + WindowManager.this.findWindowName(window) + " " + window);
                }
                WindowManager.this.app.resolveWindowDisplayHandler().hide(window, WindowManager.this.app);
            }
        });
    }

    public boolean canShutdown(GriffonApplication app) {
        return true;
    }

    public void onShutdown(GriffonApplication app) {
        for (Window window : this.windows.values()) {
            if (!window.isShowing()) continue;
            this.hide(window);
        }
    }

    public void handleClose(Window widget) {
        if (this.app.getPhase() == ApplicationPhase.SHUTDOWN) {
            return;
        }
        int visibleWindows = 0;
        for (Window window : this.windows.values()) {
            if (!window.isShowing()) continue;
            ++visibleWindows;
        }
        Boolean autoShutdown = (Boolean)this.app.getConfig().flatten().get("application.autoShutdown");
        if (visibleWindows <= 1 && autoShutdown != null && autoShutdown.booleanValue() && !this.app.shutdown()) {
            this.show(widget);
        }
    }

    private class OnWindowHiddenHelper
    implements EventHandler<WindowEvent> {
        private OnWindowHiddenHelper() {
        }

        public void handle(WindowEvent windowEvent) {
            WindowManager.this.app.event(GriffonApplication.Event.WINDOW_HIDDEN.getName(), Arrays.asList(windowEvent.getSource()));
        }
    }

    private class OnWindowShownHelper
    implements EventHandler<WindowEvent> {
        private OnWindowShownHelper() {
        }

        public void handle(WindowEvent windowEvent) {
            WindowManager.this.app.event(GriffonApplication.Event.WINDOW_SHOWN.getName(), Arrays.asList(windowEvent.getSource()));
        }
    }

    private class OnWindowHidingHelper
    implements EventHandler<WindowEvent> {
        private OnWindowHidingHelper() {
        }

        public void handle(WindowEvent event) {
            WindowManager.this.hide((Window)event.getSource());
            WindowManager.this.handleClose((Window)event.getSource());
        }
    }
}

