/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx;

import griffon.application.StandaloneGriffonApplication;
import griffon.core.UIThreadManager;
import griffon.javafx.AbstractJavaFXGriffonApplication;
import griffon.javafx.ConfigurableWindowDisplayHandler;
import griffon.javafx.JavaFXUIThreadHandler;
import griffon.javafx.WindowDisplayHandler;
import griffon.javafx.WindowManager;
import griffon.util.GriffonExceptionHandler;
import griffon.util.UIThreadHandler;
import javafx.application.Application;
import javafx.stage.Stage;
import javafx.stage.Window;

public class JavaFXGriffonApplication
extends AbstractJavaFXGriffonApplication
implements StandaloneGriffonApplication {
    private boolean primaryStageDispensed = false;
    private final WindowManager windowManager;
    private WindowDisplayHandler windowDisplayHandler;
    private final WindowDisplayHandler defaultWindowDisplayHandler = new ConfigurableWindowDisplayHandler();
    private Stage primaryStage;

    public JavaFXGriffonApplication() {
        this(EMPTY_ARGS);
    }

    public JavaFXGriffonApplication(String[] args) {
        super(args);
        this.windowManager = new WindowManager(this);
        UIThreadManager.getInstance().setUIThreadHandler(this.getUIThreadHandler());
        this.addShutdownHandler(this.windowManager);
    }

    protected UIThreadHandler getUIThreadHandler() {
        return new JavaFXUIThreadHandler();
    }

    @Override
    public Object createApplicationContainer() {
        if (this.primaryStageDispensed) {
            return new Stage();
        }
        this.primaryStageDispensed = true;
        return this.primaryStage;
    }

    @Override
    public void start(Stage stage) throws Exception {
        super.start(stage);
        this.primaryStage = stage;
        this.execOutsideUI(new Runnable(){

            @Override
            public void run() {
                try {
                    JavaFXGriffonApplication.this.bootstrap();
                    JavaFXGriffonApplication.this.realize();
                    JavaFXGriffonApplication.this.show();
                }
                catch (RuntimeException e) {
                    GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
                }
            }
        });
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public WindowDisplayHandler getWindowDisplayHandler() {
        return this.windowDisplayHandler;
    }

    public void setWindowDisplayHandler(WindowDisplayHandler windowDisplayHandler) {
        this.windowDisplayHandler = windowDisplayHandler;
    }

    public final WindowDisplayHandler resolveWindowDisplayHandler() {
        return this.windowDisplayHandler != null ? this.windowDisplayHandler : this.defaultWindowDisplayHandler;
    }

    public void bootstrap() {
        this.initialize();
    }

    public void realize() {
        this.startup();
    }

    public void show() {
        Window startingWindow = this.windowManager.getStartingWindow();
        this.windowManager.show(startingWindow);
        this.ready();
    }

    @Override
    public boolean shutdown() {
        if (super.shutdown()) {
            this.exit();
        }
        return false;
    }

    public void exit() {
        System.exit(0);
    }

    public static void run(Class<? extends Application> applicationClass, String[] args) {
        GriffonExceptionHandler.registerExceptionHandler();
        Application.launch(applicationClass, (String[])args);
    }

    public static void main(String[] args) {
        JavaFXGriffonApplication.run(JavaFXGriffonApplication.class, args);
    }
}

