/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.i18n;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeResourceBundle
extends ResourceBundle {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeResourceBundle.class);
    private final ResourceBundle[] bundles;
    private final List<String> keys = new ArrayList<String>();

    public CompositeResourceBundle(ResourceBundle[] bundles) {
        this.bundles = bundles;
        for (ResourceBundle bundle : bundles) {
            Enumeration<String> ks = bundle.getKeys();
            while (ks.hasMoreElements()) {
                String key = ks.nextElement();
                if (this.keys.contains(key)) continue;
                this.keys.add(key);
            }
        }
    }

    @Override
    protected Object handleGetObject(String key) {
        LOG.trace("Searching key = " + key + ";");
        for (ResourceBundle bundle : this.bundles) {
            try {
                Object value = bundle.getObject(key);
                LOG.trace("Bundle " + bundle + "; key = " + key + "; value='" + value + "'");
                if (value == null) continue;
                return value;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Enumeration<String> getKeys() {
        return new IteratorAsEnumeration<String>(this.keys.iterator());
    }

    private static class IteratorAsEnumeration<E>
    implements Enumeration<E> {
        private final Iterator<E> iterator;

        public IteratorAsEnumeration(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public E nextElement() {
            return this.iterator.next();
        }
    }
}

