/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.i18n;

import griffon.plugins.i18n.CompositeResourceBundle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ExtendedResourceBundleMessageSource
extends ResourceBundleMessageSource {
    private static final Logger LOG = LoggerFactory.getLogger(ExtendedResourceBundleMessageSource.class);
    private boolean resolved;
    private PathMatchingResourcePatternResolver resolver;
    private final Object[] lock = new Object[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolver() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            if (this.resolved) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.createResolver();
            this.resolved = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void createResolver() {
        this.resolver = new PathMatchingResourcePatternResolver(this.getBundleClassLoader());
    }

    protected ResourceBundle doGetBundle(String basename, Locale locale) throws MissingResourceException {
        this.resolver();
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        bundles.addAll(this.loadBundleForFilename(basename + "_" + locale.getLanguage() + "_" + locale.getCountry()));
        bundles.addAll(this.loadBundleForFilename(basename + "_" + locale.getLanguage()));
        bundles.addAll(this.loadBundleForFilename(basename));
        return new CompositeResourceBundle(bundles.toArray(new ResourceBundle[bundles.size()]));
    }

    private List<ResourceBundle> loadBundleForFilename(String filename) {
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        try {
            Resource[] resources = this.resolver.getResources("classpath*:/" + filename + ".properties");
            LOG.trace("Found " + resources.length + " matches for classpath *:/" + filename + ".properties");
            for (Resource resource : resources) {
                LOG.trace("Initializing bundle with " + resource.getURI());
                bundles.add(new PropertyResourceBundle(resource.getInputStream()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bundles;
    }
}

