/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.i18n;

import griffon.plugins.i18n.ConstrainedMessageSource;
import griffon.plugins.i18n.ConstraintNotSupportedException;
import griffon.plugins.i18n.MessageSource;
import griffon.plugins.i18n.MessageSourceProvider;
import java.util.HashMap;
import java.util.Map;

public final class MessageSourceHolder
implements MessageSourceProvider {
    private Map<String, MessageSource> messageSources = new HashMap<String, MessageSource>();
    private String provider;
    private static MessageSourceHolder INSTANCE = new MessageSourceHolder();

    public static MessageSourceHolder getInstance() {
        return INSTANCE;
    }

    @Override
    public MessageSource getMessageSource() {
        return this.getMessageSource(this.getProvider());
    }

    public MessageSource getMessageSource(Object constraint) {
        MessageSource messageSource = this.getMessageSource();
        try {
            if (messageSource instanceof ConstrainedMessageSource) {
                return ((ConstrainedMessageSource)messageSource).getMessageSource(constraint);
            }
            return messageSource;
        }
        catch (ConstraintNotSupportedException e) {
            return messageSource;
        }
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void registerMessageSource(String provider, MessageSource messageSource) {
        this.messageSources.put(provider, messageSource);
    }

    public void unregisterMessageSource(String provider) {
        this.messageSources.remove(provider);
    }

    public MessageSource getMessageSource(String provider) {
        return this.messageSources.get(provider);
    }
}

