/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.i18n;

import griffon.plugins.i18n.ConstrainedMessageSource;
import griffon.plugins.i18n.ConstraintNotSupportedException;
import griffon.plugins.i18n.MessageSource;
import java.util.HashMap;
import java.util.Map;

public final class MessageSourceHolder {
    private static Map<String, MessageSource> messageSources = new HashMap<String, MessageSource>();
    private static String provider;

    public static MessageSource getMessageSource() {
        return MessageSourceHolder.getMessageSource(MessageSourceHolder.getProvider());
    }

    public static MessageSource getMessageSource(Object constraint) {
        MessageSource messageSource = MessageSourceHolder.getMessageSource();
        try {
            if (messageSource instanceof ConstrainedMessageSource) {
                return ((ConstrainedMessageSource)messageSource).getMessageSource(constraint);
            }
            return messageSource;
        }
        catch (ConstraintNotSupportedException e) {
            return messageSource;
        }
    }

    public static String getProvider() {
        return provider;
    }

    public static void setProvider(String provider) {
        MessageSourceHolder.provider = provider;
    }

    public static void registerMessageSource(String provider, MessageSource messageSource) {
        messageSources.put(provider, messageSource);
    }

    public static void unregisterMessageSource(String provider) {
        messageSources.remove(provider);
    }

    public static MessageSource getMessageSource(String provider) {
        return messageSources.get(provider);
    }
}

