/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.DbTxn;

public class Transaction {
    final DbTxn txn;
    private boolean isCommitted = false;

    Transaction(DbTxn dbTxn) {
        this.txn = dbTxn;
    }

    public byte[] getCommitToken() throws IllegalStateException {
        if (this.isCommitted && this.txn.commitToken == null) {
            throw new IllegalArgumentException();
        }
        if (this.isCommitted && this.txn.commitToken.length == 20) {
            return this.txn.commitToken;
        }
        throw new IllegalStateException();
    }

    public void abort() throws DatabaseException {
        this.txn.abort();
    }

    public void commit() throws DatabaseException {
        this.txn.commit(0);
        this.isCommitted = true;
    }

    public void commitSync() throws DatabaseException {
        this.txn.commit(4);
        this.isCommitted = true;
    }

    public void commitNoSync() throws DatabaseException {
        this.txn.commit(1);
        this.isCommitted = true;
    }

    public void commitWriteNoSync() throws DatabaseException {
        this.txn.commit(32);
        this.isCommitted = true;
    }

    public void discard() throws DatabaseException {
        this.txn.discard(0);
    }

    public int getId() throws DatabaseException {
        return this.txn.id();
    }

    public String getName() throws DatabaseException {
        return this.txn.get_name();
    }

    public int getPriority() throws DatabaseException {
        return this.txn.get_priority();
    }

    public void prepare(byte[] byArray) throws DatabaseException {
        this.txn.prepare(byArray);
    }

    public void setName(String string) throws DatabaseException {
        this.txn.set_name(string);
    }

    public void setPriority(int n) throws DatabaseException {
        this.txn.set_priority(n);
    }

    public void setTxnTimeout(long l) throws DatabaseException {
        this.txn.set_timeout(l, 2);
    }

    public void setLockTimeout(long l) throws DatabaseException {
        this.txn.set_timeout(l, 1);
    }
}

