/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongBinding
extends TupleBinding<Long> {
    private static final int LONG_SIZE = 8;

    @Override
    public Long entryToObject(TupleInput tupleInput) {
        return tupleInput.readLong();
    }

    @Override
    public void objectToEntry(Long l, TupleOutput tupleOutput) {
        tupleOutput.writeLong(l);
    }

    @Override
    protected TupleOutput getTupleOutput(Long l) {
        return LongBinding.sizedOutput();
    }

    public static long entryToLong(DatabaseEntry databaseEntry) {
        return LongBinding.entryToInput(databaseEntry).readLong();
    }

    public static void longToEntry(long l, DatabaseEntry databaseEntry) {
        LongBinding.outputToEntry(LongBinding.sizedOutput().writeLong(l), databaseEntry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[8]);
    }
}

