/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;

public class TempLink
implements HGLink {
    private HGHandle[] array;
    private int start;
    private int end;

    public TempLink(HGHandle[] array) {
        this.setHandleArray(array);
    }

    public TempLink(HGHandle[] array, int start) {
        this.setHandleArray(array, start);
    }

    public TempLink(HGHandle[] array, int start, int end) {
        this.setHandleArray(array, start, end);
    }

    public void setHandleArray(HGHandle[] array) {
        this.array = array;
        this.start = 0;
        this.end = array.length;
    }

    public void setHandleArray(HGHandle[] array, int start) {
        this.array = array;
        this.start = start;
        this.end = array.length;
    }

    public void setHandleArray(HGHandle[] array, int start, int end) {
        this.array = array;
        this.start = start;
        this.end = end;
    }

    @Override
    public int getArity() {
        return this.end - this.start;
    }

    @Override
    public HGHandle getTargetAt(int i) {
        return this.array[this.start + i];
    }

    @Override
    public void notifyTargetHandleUpdate(int i, HGHandle handle) {
        this.array[this.start + i] = handle;
    }

    @Override
    public void notifyTargetRemoved(int i) {
        HGHandle[] newOutgoing = new HGHandle[this.array.length - 1];
        System.arraycopy(this.array, 0, newOutgoing, 0, i);
        System.arraycopy(this.array, i + 1, newOutgoing, i, this.array.length - i - 1);
        this.array = newOutgoing;
    }
}

