/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SoftHashMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, SoftValue<K, V>> hash;
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    private void processQueue() {
        SoftValue sv;
        while ((sv = (SoftValue)this.queue.poll()) != null) {
            this.hash.remove(sv.key);
        }
    }

    public SoftHashMap() {
        this.hash = new HashMap<K, SoftValue<K, V>>();
    }

    public SoftHashMap(int initialCapacity) {
        this.hash = new HashMap<K, SoftValue<K, V>>(initialCapacity);
    }

    public SoftHashMap(int initialCapacity, float loadFactor) {
        this.hash = new HashMap<K, SoftValue<K, V>>(initialCapacity, loadFactor);
    }

    public SoftHashMap(Map<? extends K, ? extends V> m) {
        this();
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.hash.put(e.getKey(), new SoftValue(e.getKey(), e.getValue(), this.queue));
        }
    }

    @Override
    public V get(Object key) {
        V result = null;
        SoftValue<K, V> soft_ref = this.hash.get(key);
        if (soft_ref != null && (result = (V)soft_ref.get()) == null) {
            this.hash.remove(key);
        }
        return result;
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        this.hash.put(key, new SoftValue(key, value, this.queue));
        return value;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        SoftValue<K, V> soft = this.hash.remove(key);
        return soft == null ? null : (V)soft.get();
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.hash.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final Set<Map.Entry<K, SoftValue<K, V>>> s = this.hash.entrySet();
        return new Set<Map.Entry<K, V>>(){

            @Override
            public boolean add(Map.Entry<K, V> e) {
                return s.add(new E(e.getKey(), e.getValue()));
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                boolean result = false;
                for (Map.Entry e : c) {
                    if (!this.add(e)) continue;
                    result = true;
                }
                return result;
            }

            @Override
            public void clear() {
                s.clear();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return s.contains(new E(e.getKey(), e.getValue()));
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object x : c) {
                    if (this.contains(x)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean isEmpty() {
                return s.isEmpty();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator i = s.iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public void remove() {
                        i.remove();
                    }

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Map.Entry e = (Map.Entry)i.next();
                        return new F(e.getKey(), ((SoftValue)e.getValue()).get());
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return s.remove(new E(e.getKey(), e.getValue()));
            }

            @Override
            public boolean removeAll(Collection c) {
                boolean result = false;
                for (Object x : c) {
                    if (!this.remove(x)) continue;
                    result = true;
                }
                return result;
            }

            @Override
            public boolean retainAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return s.size();
            }

            @Override
            public Object[] toArray() {
                return this.toArray((Object[])null);
            }

            @Override
            public Object[] toArray(Object[] a) {
                Object[] result = null;
                result = a != null && a instanceof F[] && a.length >= this.size() ? (F[])a : new F[this.size()];
                Object[] A = s.toArray();
                for (int i = 0; i < A.length; ++i) {
                    Map.Entry e = (Map.Entry)A[i];
                    result[i] = new F(e.getKey(), ((SoftValue)e.getValue()).get());
                }
                return result;
            }
        };
    }

    private static class F<K, V>
    implements Map.Entry<K, V> {
        private K k;
        private V v;

        public F(K k, V v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public V getValue() {
            return this.v;
        }

        @Override
        public V setValue(V v) {
            V old = v;
            this.v = v;
            return old;
        }

        @Override
        public K getKey() {
            return this.k;
        }
    }

    private class E
    implements Map.Entry<K, SoftValue<K, V>> {
        private K k;
        private SoftValue<K, V> v;

        public E(K k, V v) {
            this.k = k;
            this.v = new SoftValue(k, v, SoftHashMap.this.queue);
        }

        @Override
        public SoftValue<K, V> getValue() {
            return this.v;
        }

        @Override
        public SoftValue<K, V> setValue(SoftValue<K, V> v) {
            SoftValue old = v;
            this.v = v;
            return old;
        }

        @Override
        public K getKey() {
            return this.k;
        }
    }

    private static class SoftValue<Ka, Va>
    extends SoftReference<Va> {
        private final Ka key;

        private SoftValue(Ka aKey, Va aValue, ReferenceQueue<Va> q) {
            super(aValue, q);
            this.key = aKey;
        }
    }
}

