/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import java.util.NoSuchElementException;

public class SimplyLinkedQueue<T> {
    private int size = 0;
    private Node<T> head;
    private Node<T> tail;

    public void put(T data) {
        Node<T> n = new Node<T>(data, null);
        if (this.tail != null) {
            this.tail.next = n;
            this.tail = this.tail.next;
        } else {
            this.tail = n;
            this.head = this.tail;
        }
        ++this.size;
    }

    public T fetch() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        Object result = this.head.data;
        this.head = this.head.next;
        if (this.head == null) {
            this.tail = null;
        }
        --this.size;
        return result;
    }

    public T peekFront() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        return this.head.data;
    }

    public T peekBack() {
        if (this.tail == null) {
            throw new NoSuchElementException();
        }
        return this.tail.data;
    }

    public boolean isEmpty() {
        return this.tail == null;
    }

    public int size() {
        return this.size;
    }

    private static class Node<T> {
        T data;
        Node<T> next;

        public Node(T data, Node<T> next) {
            this.data = data;
            this.next = next;
        }
    }
}

