/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import java.util.NoSuchElementException;

public class SimpleStack<T> {
    private int size = 0;
    private Node<T> top = null;

    public void push(T data) {
        this.top = new Node<T>(data, this.top);
        ++this.size;
    }

    public T peek() {
        if (this.top == null) {
            throw new NoSuchElementException();
        }
        return this.top.data;
    }

    public T peek(int depth) {
        if (depth >= this.size) {
            throw new NoSuchElementException();
        }
        Node<T> curr = this.top;
        while (depth-- > 0) {
            curr = curr.next;
        }
        return curr.data;
    }

    public T pop() {
        if (this.top == null) {
            throw new NoSuchElementException();
        }
        Object x = this.top.data;
        this.top = this.top.next;
        --this.size;
        return x;
    }

    public boolean isEmpty() {
        return this.top == null;
    }

    public int size() {
        return this.size;
    }

    private static class Node<T> {
        T data;
        Node<T> next;

        public Node(T data, Node<T> next) {
            this.data = data;
            this.next = next;
        }
    }
}

