/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class MemoryWarningSystem {
    private final Collection<Listener> listeners = new ArrayList<Listener>();
    private MemoryPoolMXBean tenuredGenPool = null;

    public MemoryWarningSystem() {
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        this.tenuredGenPool = this.findTenuredGenPool();
        NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
        emitter.addNotificationListener(new NotificationListener(){

            @Override
            public void handleNotification(Notification n, Object hb) {
                if (n.getType().equals("java.management.memory.threshold.exceeded")) {
                    long maxMemory = MemoryWarningSystem.this.tenuredGenPool.getUsage().getMax();
                    long usedMemory = MemoryWarningSystem.this.tenuredGenPool.getUsage().getUsed();
                    for (Listener listener : MemoryWarningSystem.this.listeners) {
                        listener.memoryUsageLow(usedMemory, maxMemory);
                    }
                }
            }
        }, null, null);
    }

    public boolean addListener(Listener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    public void setPercentageUsageThreshold(double percentage) {
        if (percentage <= 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("Percentage not in range");
        }
        long maxMemory = this.tenuredGenPool.getUsage().getMax();
        long warningThreshold = (long)((double)maxMemory * percentage);
        this.tenuredGenPool.setUsageThreshold(warningThreshold);
    }

    public double getPercentageUsageThreshold() {
        long maxMemory = this.tenuredGenPool.getUsage().getMax();
        long warningThreshold = this.tenuredGenPool.getUsageThreshold();
        return (double)warningThreshold / (double)maxMemory;
    }

    private MemoryPoolMXBean findTenuredGenPool() {
        MemoryPoolMXBean last = null;
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            last = pool;
        }
        if (last != null) {
            return last;
        }
        throw new AssertionError((Object)"Could not find tenured space");
    }

    public static interface Listener {
        public void memoryUsageLow(long var1, long var3);
    }
}

