/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.hypergraphdb.util.Mapping;

public class FilterIterator<T>
implements Iterator<T> {
    private Iterator<T> iter;
    private Mapping<T, Boolean> ignore;
    private T lookahead;

    public FilterIterator(Iterator<T> iter, Mapping<T, Boolean> ignore) {
        this.iter = iter;
        this.ignore = ignore;
        this.lookahead = this.advance();
    }

    T advance() {
        while (this.iter.hasNext()) {
            T n = this.iter.next();
            if (this.ignore.eval(n).booleanValue()) continue;
            return n;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.lookahead != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T x = this.lookahead;
        this.lookahead = this.advance();
        return x;
    }

    @Override
    public void remove() {
        this.iter.remove();
    }
}

