/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.util.CloneMe;
import org.hypergraphdb.util.HGSortedSet;

public class ArrayBasedSet<E>
implements HGSortedSet<E>,
CloneMe {
    Class<E> type;
    E[] array;
    Comparator<E> comparator = null;
    int size = 0;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    int lookup(E key) {
        Comparable ckey;
        int low = 0;
        int high = this.size - 1;
        Comparable comparable = ckey = this.comparator == null ? (Comparable)key : null;
        while (low <= high) {
            int cmp;
            int mid = low + high >> 1;
            E midVal = this.array[mid];
            int n = cmp = ckey == null ? this.comparator.compare(midVal, key) : -ckey.compareTo(midVal);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public ArrayBasedSet(E[] A) {
        this(A, null);
    }

    public ArrayBasedSet(E[] A, int capacity) {
        this(A, capacity, null);
    }

    public ArrayBasedSet(E[] A, int capacity, Comparator<E> comparator) {
        this.type = A.getClass().getComponentType();
        this.array = (Object[])Array.newInstance(this.type, capacity);
        this.size = 0;
        this.comparator = comparator;
    }

    public ArrayBasedSet(E[] A, Comparator<E> comparator) {
        this.comparator = comparator;
        this.type = A.getClass().getComponentType();
        this.array = (Object[])Array.newInstance(this.type, A.length);
        System.arraycopy(A, 0, this.array, 0, A.length);
        this.size = A.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromArray(E[] A) {
        this.lock.writeLock().lock();
        try {
            if (this.array.length < A.length) {
                this.array = (Object[])Array.newInstance(this.type, A.length);
            }
            System.arraycopy(A, 0, this.array, 0, A.length);
            this.size = A.length;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public void setLock(ReadWriteLock lock) {
        if (lock == null) {
            throw new NullPointerException("ArrayBasedSet.lock can't be null.");
        }
        this.lock = lock;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E getAt(int i) {
        this.lock.readLock().lock();
        try {
            if (i < 0 || i > this.size()) {
                throw new IllegalArgumentException("index " + i + " out of bounds [0," + this.size() + ").");
            }
            E e = this.array[i];
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E removeAt(int i) {
        this.lock.writeLock().lock();
        try {
            if (i < 0 || i > this.size()) {
                throw new IllegalArgumentException("index " + i + " out of bounds [0," + this.size() + ").");
            }
            E result = this.array[i];
            if (i < this.size - 1) {
                System.arraycopy(this.array, i + 1, this.array, i, this.size - i - 1);
            }
            --this.size;
            E e = result;
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E first() {
        this.lock.readLock().lock();
        try {
            if (this.size == 0) {
                throw new NoSuchElementException();
            }
            E e = this.array[0];
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        throw new UnsupportedOperationException("...because of lazy implementor: this is a TODO.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E last() {
        this.lock.readLock().lock();
        try {
            if (this.size == 0) {
                throw new NoSuchElementException();
            }
            E e = this.array[this.size - 1];
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        throw new UnsupportedOperationException("...because of lazy implementor: this is a TODO.");
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        throw new UnsupportedOperationException("...because of lazy implementor: this is a TODO.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E o) {
        this.lock.writeLock().lock();
        try {
            int idx = this.lookup(o);
            if (idx >= 0) {
                boolean bl = false;
                return bl;
            }
            idx = -(idx + 1);
            if (this.size < this.array.length) {
                System.arraycopy(this.array, idx, this.array, idx + 1, this.size - idx);
                this.array[idx] = o;
            } else {
                Object[] tmp = (Object[])Array.newInstance(this.type, (int)(1.5 * (double)this.size) + 1);
                System.arraycopy(this.array, 0, tmp, 0, idx);
                tmp[idx] = o;
                System.arraycopy(this.array, idx, tmp, idx + 1, this.size - idx);
                this.array = tmp;
            }
            ++this.size;
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E x : c) {
            if (!this.add(x)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        this.size = 0;
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.lookup(o) >= 0;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object x : c) {
            if (this.contains(x)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.size == 0;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new ResultSet(false);
    }

    @Override
    public HGRandomAccessResult<E> getSearchResult() {
        return new ResultSet(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        this.lock.writeLock().lock();
        try {
            int idx = this.lookup(o);
            if (idx < 0) {
                boolean bl = false;
                return bl;
            }
            if (idx < this.size - 1) {
                System.arraycopy(this.array, idx + 1, this.array, idx, this.size - idx - 1);
            }
            --this.size;
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object x : c) {
            if (!this.remove(x)) continue;
            modified = true;
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        this.lock.writeLock().lock();
        try {
            boolean modified = false;
            for (int i = 0; i < this.size; ++i) {
                if (c.contains(this.array[i])) continue;
                System.arraycopy(this.array, i + 1, this.array, i, this.size - i);
                --this.size;
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.lock.readLock().lock();
        try {
            Object[] A = new Object[this.array.length];
            System.arraycopy(this.array, 0, A, 0, this.array.length);
            Object[] objectArray = A;
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public ArrayBasedSet<E> clone() {
        try {
            ArrayBasedSet S = (ArrayBasedSet)super.clone();
            S.array = this.array.getClass() == Object[].class ? new Object[this.size] : (Object[])Array.newInstance(this.array.getClass().getComponentType(), this.size);
            System.arraycopy(this.array, 0, S.array, 0, this.size);
            return S;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        this.lock.readLock().lock();
        try {
            if (a.length < this.size) {
                Class<?> type = a.getClass();
                Object[] copy = type == Object[].class ? new Object[this.size] : (Object[])Array.newInstance(type.getComponentType(), this.size);
                System.arraycopy(this.array, 0, copy, 0, Math.min(this.array.length, this.size));
                Object[] objectArray = copy;
                return objectArray;
            }
            System.arraycopy(this.array, 0, a, 0, this.size);
            if (a.length > this.size) {
                a[this.size] = null;
            }
            T[] TArray = a;
            return TArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    class ResultSet
    implements HGRandomAccessResult<E> {
        int pos = -1;
        boolean locked;

        ResultSet(boolean locked) {
            this.locked = locked;
            if (locked) {
                ArrayBasedSet.this.lock.readLock().lock();
            }
        }

        @Override
        public HGRandomAccessResult.GotoResult goTo(E value, boolean exactMatch) {
            int idx = ArrayBasedSet.this.lookup(value);
            if (idx >= 0) {
                this.pos = idx;
                return HGRandomAccessResult.GotoResult.found;
            }
            if (exactMatch) {
                return HGRandomAccessResult.GotoResult.nothing;
            }
            if ((idx = -(idx + 1)) >= ArrayBasedSet.this.size) {
                return HGRandomAccessResult.GotoResult.nothing;
            }
            this.pos = idx;
            return HGRandomAccessResult.GotoResult.close;
        }

        @Override
        public void goBeforeFirst() {
            this.pos = -1;
        }

        @Override
        public void goAfterLast() {
            this.pos = ArrayBasedSet.this.size;
        }

        @Override
        public boolean hasPrev() {
            return this.pos > 0;
        }

        @Override
        public E prev() {
            return ArrayBasedSet.this.array[--this.pos];
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < ArrayBasedSet.this.size;
        }

        @Override
        public E next() {
            return ArrayBasedSet.this.array[++this.pos];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("...because of lazy implementor: this is a TODO.");
        }

        @Override
        public void close() {
            if (this.locked) {
                ArrayBasedSet.this.lock.readLock().unlock();
                this.locked = false;
            }
        }

        @Override
        public E current() {
            if (this.pos < 0 || this.pos >= ArrayBasedSet.this.size) {
                throw new NoSuchElementException();
            }
            return ArrayBasedSet.this.array[this.pos];
        }

        @Override
        public boolean isOrdered() {
            return true;
        }
    }
}

