/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import org.hypergraphdb.util.HGLogger;

public class ActionQueueThread
extends Thread {
    public static final int DEFAULT_NON_BLOCKING_SIZE = 1000;
    public static final int DEFAULT_FREE_PERCENT_ON_BLOCK = 30;
    private HGLogger logger = new HGLogger();
    private LinkedList<Runnable> actionList = new LinkedList();
    private int nonBlockingSize = 1000;
    private double freeFactor = 0.9666666666666667;
    private boolean running = false;
    private long completedCount = 0L;
    private Semaphore pauseMutex = new Semaphore(1);

    public ActionQueueThread() {
    }

    public ActionQueueThread(String name) {
        super(name);
    }

    public ActionQueueThread(String name, int maxSizeBeforeBlock, int completePercentUponBlocking) {
        this(name);
        this.nonBlockingSize = maxSizeBeforeBlock;
        this.freeFactor = 1.0 - 1.0 / (double)completePercentUponBlocking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Runnable action;
        this.running = true;
        while (this.running) {
            action = null;
            LinkedList<Runnable> linkedList = this.actionList;
            synchronized (linkedList) {
                while (this.actionList.isEmpty() && this.running) {
                    try {
                        this.actionList.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.actionList.isEmpty()) {
                    break;
                }
                action = this.actionList.removeFirst();
            }
            try {
                this.pauseMutex.acquire();
                action.run();
            }
            catch (InterruptedException ex) {
                break;
            }
            catch (Throwable t) {
                this.logger.exception(t);
            }
            finally {
                ++this.completedCount;
                this.pauseMutex.release();
            }
        }
        while (!this.actionList.isEmpty()) {
            action = this.actionList.removeFirst();
            action.run();
        }
    }

    public void pauseActions() {
        try {
            this.pauseMutex.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void resumeActions() {
        this.pauseMutex.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAction(Runnable action) {
        if (this.actionList.size() > this.nonBlockingSize) {
            while ((double)this.actionList.size() > (double)this.nonBlockingSize * this.freeFactor) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                    break;
                }
            }
        }
        LinkedList<Runnable> linkedList = this.actionList;
        synchronized (linkedList) {
            this.actionList.addLast(action);
            this.actionList.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prependAction(Runnable action) {
        LinkedList<Runnable> linkedList = this.actionList;
        synchronized (linkedList) {
            this.actionList.addFirst(action);
            this.actionList.notify();
        }
    }

    public void completeAll() {
        long currentCompleted = this.completedCount;
        int size = Math.max(1, this.actionList.size());
        while (this.completedCount - currentCompleted < (long)size && (this.getState() == Thread.State.BLOCKED || this.getState() == Thread.State.RUNNABLE)) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        LinkedList<Runnable> linkedList = this.actionList;
        synchronized (linkedList) {
            this.actionList.clear();
        }
    }

    public long getCompletedCount() {
        return this.completedCount;
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRunning() {
        this.running = false;
        LinkedList<Runnable> linkedList = this.actionList;
        synchronized (linkedList) {
            this.actionList.notify();
        }
    }
}

