/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.util;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import org.hypergraphdb.HGException;
import org.hypergraphdb.util.Pair;
import org.hypergraphdb.util.SoftHashMap;

public class AccessibleObjectCache {
    private Map<Pair<Class<?>, String>, Field> fields = Collections.synchronizedMap(new SoftHashMap());

    private Field findField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Field result = null;
        while (clazz != null && result == null) {
            Field[] all = clazz.getDeclaredFields();
            for (int i = 0; i < all.length; ++i) {
                if (!all[i].getName().equals(fieldName)) continue;
                result = all[i];
                result.setAccessible(true);
                break;
            }
            clazz = clazz.getSuperclass();
        }
        if (result == null) {
            throw new NoSuchFieldException("Class " + clazz.getName() + ", field " + fieldName);
        }
        return result;
    }

    public Field getField(Class<?> clazz, String fieldName) {
        Pair key = new Pair(clazz, fieldName);
        Field f = this.fields.get(key);
        if (f == null) {
            try {
                f = this.findField(clazz, fieldName);
            }
            catch (Exception ex) {
                throw new HGException(ex);
            }
            this.fields.put(key, f);
        }
        return f;
    }
}

