/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type.javaprimitive;

import java.util.Comparator;
import org.hypergraphdb.type.javaprimitive.PrimitiveTypeBase;

public final class StringType
extends PrimitiveTypeBase<String> {
    public static final String INDEX_NAME = "hg_string_value_index";
    private static final StringComparator comp = new StringComparator();

    @Override
    public Comparator<byte[]> getComparator() {
        return comp;
    }

    @Override
    protected String getIndexName() {
        return INDEX_NAME;
    }

    private byte[] stringToBytes(String s) {
        byte[] data;
        if (s == null) {
            data = new byte[]{0};
        } else if (s.length() == 0) {
            data = new byte[]{1};
        } else {
            byte[] asBytes = s.getBytes();
            data = new byte[1 + asBytes.length];
            data[0] = 2;
            System.arraycopy(asBytes, 0, data, 1, asBytes.length);
        }
        return data;
    }

    @Override
    protected byte[] writeBytes(String value) {
        return this.stringToBytes(value);
    }

    @Override
    protected String readBytes(byte[] data, int offset) {
        switch (data[offset]) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
        }
        return new String(data, offset + 1, data.length - offset - 1);
    }

    public static class StringComparator
    implements Comparator<byte[]> {
        @Override
        public int compare(byte[] left, byte[] right) {
            int i;
            if (left[4] < 2) {
                if (right[4] < 2) {
                    if (left[4] < right[4]) {
                        return -1;
                    }
                    if (left[4] == right[4]) {
                        return 0;
                    }
                    return 1;
                }
                return -1;
            }
            if (right[4] < 2) {
                return 1;
            }
            for (i = 5; i < left.length && i < right.length; ++i) {
                if (left[i] < right[i]) {
                    return -1;
                }
                if (left[i] <= right[i]) continue;
                return 1;
            }
            if (i == left.length) {
                if (i == right.length) {
                    return 0;
                }
                return -1;
            }
            return 1;
        }
    }
}

