/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type.javaprimitive;

import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.type.javaprimitive.PrimitiveArrayType;

public class ShortPrimitiveArrayType
extends PrimitiveArrayType {
    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        byte[] data = this.hg.getStore().getData(handle);
        if (data == null) {
            throw new HGException("Could not find value for short array, handle=" + handle.toString());
        }
        short[] A = new short[(data.length - 1) / 2];
        for (int i = 0; i < A.length; ++i) {
            int offset = 2 * i + 1;
            A[i] = (short)(((data[offset + 1] & 0xFF) << 0) + (data[offset] << 8));
        }
        return A;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        short[] A = (short[])instance;
        byte[] data = new byte[2 * A.length + 1];
        data[0] = (byte)(A.length != 0 ? 1 : 0);
        for (int i = 0; i < A.length; ++i) {
            short v = A[i];
            int offset = 2 * i + 1;
            data[offset + 1] = (byte)(v >>> 0);
            data[offset] = (byte)(v >>> 8);
        }
        return this.hg.getStore().store(data);
    }
}

