/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type.javaprimitive;

import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.type.javaprimitive.PrimitiveArrayType;

public class LongPrimitiveArrayType
extends PrimitiveArrayType {
    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        byte[] data = this.hg.getStore().getData(handle);
        if (data == null) {
            throw new HGException("Could not find value for long array, handle=" + handle.toString());
        }
        long[] result = new long[(data.length - 1) / 8];
        for (int i = 0; i < result.length; ++i) {
            long lv;
            int l = 8 * i + 1;
            result[i] = lv = ((long)data[l] << 56) + ((long)(data[l + 1] & 0xFF) << 48) + ((long)(data[l + 2] & 0xFF) << 40) + ((long)(data[l + 3] & 0xFF) << 32) + ((long)(data[l + 4] & 0xFF) << 24) + (long)((data[l + 5] & 0xFF) << 16) + (long)((data[l + 6] & 0xFF) << 8) + (long)((data[l + 7] & 0xFF) << 0);
        }
        return result;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        long[] A = (long[])instance;
        byte[] data = new byte[A.length * 8 + 1];
        data[0] = (byte)(A.length != 0 ? 1 : 0);
        for (int i = 0; i < A.length; ++i) {
            long v = A[i];
            int j = 8 * i + 1;
            data[j + 0] = (byte)(v >>> 56);
            data[j + 1] = (byte)(v >>> 48);
            data[j + 2] = (byte)(v >>> 40);
            data[j + 3] = (byte)(v >>> 32);
            data[j + 4] = (byte)(v >>> 24);
            data[j + 5] = (byte)(v >>> 16);
            data[j + 6] = (byte)(v >>> 8);
            data[j + 7] = (byte)(v >>> 0);
        }
        return this.hg.getStore().store(data);
    }
}

