/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type.javaprimitive;

import java.util.Comparator;
import org.hypergraphdb.type.javaprimitive.PrimitiveTypeBase;

public class FloatType
extends PrimitiveTypeBase<Float> {
    public static final String INDEX_NAME = "hg_float_value_index";
    private static final FloatComparator comp = new FloatComparator();

    @Override
    public Comparator<byte[]> getComparator() {
        return comp;
    }

    @Override
    protected String getIndexName() {
        return INDEX_NAME;
    }

    @Override
    protected byte[] writeBytes(Float value) {
        byte[] data = new byte[4];
        int i = Float.floatToIntBits(value.floatValue());
        data[3] = (byte)(i >>> 0);
        data[2] = (byte)(i >>> 8);
        data[1] = (byte)(i >>> 16);
        data[0] = (byte)(i >>> 24);
        return data;
    }

    @Override
    protected Float readBytes(byte[] bytes, int offset) {
        return new Float(FloatType.bytesToFloat(bytes));
    }

    private static float bytesToFloat(byte[] b) {
        int l = b.length - 4;
        int i = ((b[l + 3] & 0xFF) << 0) + ((b[l + 2] & 0xFF) << 8) + ((b[l + 1] & 0xFF) << 16) + (b[l + 0] << 24);
        return Float.intBitsToFloat(i);
    }

    public static class FloatComparator
    implements Comparator<byte[]> {
        @Override
        public int compare(byte[] left, byte[] right) {
            byte[] left_f = new byte[4];
            System.arraycopy(left, 4, left_f, 0, 4);
            byte[] right_f = new byte[4];
            System.arraycopy(right, 4, right_f, 0, 4);
            return Float.compare(FloatType.bytesToFloat(left_f), FloatType.bytesToFloat(right_f));
        }
    }
}

