/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type.javaprimitive;

import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.type.HGAtomTypeBase;
import org.hypergraphdb.type.javaprimitive.EnumType;
import org.hypergraphdb.util.HGUtils;

public class EnumTypeConstructor
extends HGAtomTypeBase {
    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        EnumType result = new EnumType();
        result.setHyperGraph(this.graph);
        HGPersistentHandle[] layout = this.graph.getStore().getLink(handle);
        Object stringType = this.graph.getTypeSystem().getAtomType(String.class);
        String classname = (String)stringType.make(layout[0], null, null);
        try {
            Class<Enum> cl = HGUtils.loadClass(this.getHyperGraph(), classname);
            result.setEnumType(cl);
        }
        catch (ClassNotFoundException ex) {
            throw new HGException("Unable to load enum class " + classname, ex);
        }
        return result;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        EnumType et = (EnumType)instance;
        if (!et.getEnumType().isEnum()) {
            throw new HGException("Attempting to store non Enum class " + et.getEnumType().getClass() + " as an enum.");
        }
        HGPersistentHandle[] layout = new HGPersistentHandle[1 + et.getEnumType().getEnumConstants().length];
        Object stringType = this.graph.getTypeSystem().getAtomType(String.class);
        layout[0] = stringType.store(et.getEnumType().getName());
        Enum[] constants = (Enum[])et.getEnumType().getEnumConstants();
        for (int i = 0; i < constants.length; ++i) {
            layout[i + 1] = stringType.store(constants[i].name());
        }
        return this.graph.getStore().store(layout);
    }

    @Override
    public void release(HGPersistentHandle handle) {
        HGPersistentHandle[] layout = this.graph.getStore().getLink(handle);
        Object stringType = this.graph.getTypeSystem().getAtomType(String.class);
        for (HGPersistentHandle h : layout) {
            stringType.release(h);
        }
        this.graph.getStore().removeLink(handle);
    }
}

