/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type.javaprimitive;

import java.util.Comparator;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.storage.BAUtils;
import org.hypergraphdb.storage.ByteArrayConverter;
import org.hypergraphdb.type.HGAtomTypeBase;

public class EnumType
extends HGAtomTypeBase
implements ByteArrayConverter,
Comparator {
    private Class<Enum> enumType;

    public EnumType() {
    }

    public EnumType(Class<Enum> enumType) {
        this.enumType = enumType;
    }

    public final Class<?> getEnumType() {
        return this.enumType;
    }

    public final void setEnumType(Class<Enum> enumType) {
        this.enumType = enumType;
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        HGPersistentHandle[] layout = this.graph.getStore().getLink(handle);
        if (layout == null || layout.length != 1) {
            throw new HGException("EnumType.make: wrong or inexisting layout for handle " + handle);
        }
        Object stringType = this.graph.getTypeSystem().getAtomType(String.class);
        String symbol = (String)stringType.make(layout[0], null, null);
        return Enum.valueOf(this.enumType, symbol);
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        Enum e = (Enum)instance;
        if (!e.getClass().equals(this.enumType)) {
            throw new HGException("Attempting to store an enum instance of the wrong type " + e.getClass().getName() + ", expected " + this.enumType.getName());
        }
        Object stringType = this.graph.getTypeSystem().getAtomType(String.class);
        HGPersistentHandle[] layout = new HGPersistentHandle[]{stringType.store(e.name())};
        return this.graph.getStore().store(layout);
    }

    @Override
    public void release(HGPersistentHandle handle) {
        HGPersistentHandle[] layout = this.graph.getStore().getLink(handle);
        if (layout == null || layout.length != 1) {
            throw new HGException("EnumType.release: wrong or inexisting layout for handle " + handle);
        }
        Object stringType = this.graph.getTypeSystem().getAtomType(String.class);
        stringType.release(layout[0]);
        this.graph.getStore().removeLink(handle);
    }

    public Object fromByteArray(byte[] byteArray) {
        int ordinal = BAUtils.readInt(byteArray, 0);
        return this.enumType.getEnumConstants()[ordinal];
    }

    public byte[] toByteArray(Object object) {
        Enum e = (Enum)object;
        byte[] B = new byte[4];
        BAUtils.writeInt(e == null ? -1 : e.ordinal(), B, 0);
        return B;
    }

    public int compare(Object o1, Object o2) {
        byte[] left = (byte[])o1;
        byte[] right = (byte[])o2;
        for (int i = 0; i < left.length && i < right.length; ++i) {
            if (left[i] - right[i] == 0) continue;
            return left[i] - right[i];
        }
        return 0;
    }
}

