/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type.javaprimitive;

import java.util.Comparator;
import java.util.TimeZone;
import org.hypergraphdb.type.javaprimitive.NumericTypeBase;
import org.hypergraphdb.type.javaprimitive.PrimitiveTypeBase;

public abstract class DateTypeBase<JavaType>
extends PrimitiveTypeBase<JavaType> {
    public static final String INDEX_NAME = "hg_time_value_index";

    protected abstract long toLong(JavaType var1);

    protected abstract JavaType fromLong(long var1);

    @Override
    protected String getIndexName() {
        return INDEX_NAME;
    }

    @Override
    protected JavaType readBytes(byte[] bytes, int offset) {
        long x = ((long)bytes[offset] << 56) + ((long)(bytes[offset + 1] & 0xFF) << 48) + ((long)(bytes[offset + 2] & 0xFF) << 40) + ((long)(bytes[offset + 3] & 0xFF) << 32) + ((long)(bytes[offset + 4] & 0xFF) << 24) + (long)((bytes[offset + 5] & 0xFF) << 16) + (long)((bytes[offset + 6] & 0xFF) << 8) + (long)((bytes[offset + 7] & 0xFF) << 0);
        return this.fromLong(x + (long)TimeZone.getDefault().getRawOffset());
    }

    @Override
    protected byte[] writeBytes(JavaType value) {
        byte[] data = new byte[8];
        long v = this.toLong(value) - (long)TimeZone.getDefault().getRawOffset();
        data[0] = (byte)(v >>> 56);
        data[1] = (byte)(v >>> 48);
        data[2] = (byte)(v >>> 40);
        data[3] = (byte)(v >>> 32);
        data[4] = (byte)(v >>> 24);
        data[5] = (byte)(v >>> 16);
        data[6] = (byte)(v >>> 8);
        data[7] = (byte)(v >>> 0);
        return data;
    }

    @Override
    public Comparator<byte[]> getComparator() {
        return NumericTypeBase.COMPARATOR;
    }
}

