/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type.javaprimitive;

import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.type.javaprimitive.PrimitiveArrayType;

public class CharPrimitiveArrayType
extends PrimitiveArrayType {
    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        byte[] data = this.hg.getStore().getData(handle);
        if (data == null) {
            throw new HGException("Could not find value for char array, handle=" + handle.toString());
        }
        char[] result = new char[(data.length - 1) / 2];
        for (int i = 0; i < result.length; ++i) {
            byte ch1 = data[2 * i + 1];
            byte ch2 = data[2 * i + 1 + 1];
            result[i] = (char)((ch1 << 8) + (ch2 << 0));
        }
        return result;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        char[] A = (char[])instance;
        byte[] data = new byte[1 + A.length * 2];
        data[0] = (byte)(A.length != 0 ? 1 : 0);
        for (int i = 0; i < A.length; ++i) {
            data[1 + 2 * i] = (byte)(A[i] >>> 8 & 0xFF);
            data[1 + 2 * i + 1] = (byte)(A[i] >>> 0 & 0xFF);
        }
        return this.hg.getStore().store(data);
    }
}

