/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type.javaprimitive;

import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.type.javaprimitive.PrimitiveArrayType;

public class BytePrimitiveArrayType
extends PrimitiveArrayType {
    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        byte[] data = this.hg.getStore().getData(handle);
        if (data == null) {
            throw new HGException("Could not find value for byte array, handle=" + handle.toString());
        }
        byte[] result = new byte[data.length - 1];
        System.arraycopy(data, 1, result, 0, result.length);
        return result;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        byte[] A = (byte[])instance;
        byte[] data = new byte[A.length + 1];
        data[0] = (byte)(A.length != 0 ? 1 : 0);
        System.arraycopy(A, 0, data, 1, A.length);
        return this.hg.getStore().store(data);
    }
}

