/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type.javaprimitive;

import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.type.javaprimitive.PrimitiveArrayType;

public class BooleanPrimitiveArrayType
extends PrimitiveArrayType {
    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        byte[] data = this.hg.getStore().getData(handle);
        if (data == null) {
            throw new HGException("Could not find value for boolean array, handle=" + handle.toString());
        }
        boolean[] result = new boolean[data.length - 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = data[i + 1] == 1;
        }
        return result;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        boolean[] A = (boolean[])instance;
        byte[] data = new byte[A.length + 1];
        data[0] = (byte)(A.length != 0 ? 1 : 0);
        for (int i = 0; i < A.length; ++i) {
            data[i + 1] = A[i] ? (byte)1 : 0;
        }
        return this.hg.getStore().store(data);
    }
}

