/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.util.HashMap;
import java.util.Iterator;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGIndex;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HGSearchable;
import org.hypergraphdb.HGTypeSystem;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.storage.BAtoBA;
import org.hypergraphdb.storage.BAtoHandle;
import org.hypergraphdb.type.HGCompositeType;
import org.hypergraphdb.type.HGProjection;
import org.hypergraphdb.type.Slot;
import org.hypergraphdb.type.Top;

public final class SlotType
implements HGCompositeType,
HGSearchable<Slot, HGPersistentHandle> {
    public static final String INDEX_NAME = "hg_slot_value_index";
    public static final String LABEL_DIMENSION = "label";
    public static final String VALUE_TYPE_DIMENSION = "valueType";
    private HyperGraph hg;
    private HGIndex<byte[], HGPersistentHandle> slotIndex = null;
    private HashMap<String, HGProjection> projections = null;

    private byte[] slotToByteArray(Slot slot) {
        HGPersistentHandle valueType = this.hg.getPersistentHandle(slot.getValueType());
        byte[] valueTypeAsBytes = valueType.toByteArray();
        byte[] labelAsBytes = slot.getLabel().getBytes();
        byte[] result = new byte[valueTypeAsBytes.length + labelAsBytes.length];
        System.arraycopy(valueTypeAsBytes, 0, result, 0, valueTypeAsBytes.length);
        System.arraycopy(labelAsBytes, 0, result, valueTypeAsBytes.length, labelAsBytes.length);
        return result;
    }

    private HGIndex<byte[], HGPersistentHandle> getIndex() {
        if (this.slotIndex == null) {
            this.slotIndex = this.hg.getStore().getIndex(INDEX_NAME, BAtoBA.getInstance(), BAtoHandle.getInstance(this.hg.getHandleFactory()), null, true);
        }
        return this.slotIndex;
    }

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        this.hg = hg2;
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        HGPersistentHandle[] layout = this.hg.getStore().getLink(handle);
        Object labelType = this.hg.getTypeSystem().getAtomType(String.class);
        String label = (String)labelType.make(layout[1], null, null);
        return new Slot(label, layout[0]);
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        Slot slot = (Slot)instance;
        HGTypeSystem typeSystem = this.hg.getTypeSystem();
        HGPersistentHandle valueTypeHandle = this.hg.getPersistentHandle(slot.getValueType());
        if (this.getIndex().findFirst(this.slotToByteArray(slot)) != null) {
            throw new HGException("Attempting to create a duplicate slot: [name=" + slot.getLabel() + ", value type=" + valueTypeHandle);
        }
        Object stringType = typeSystem.getAtomType(String.class);
        HGPersistentHandle labelHandle = stringType.store(slot.getLabel());
        HGPersistentHandle handle = this.hg.getStore().store(new HGPersistentHandle[]{this.hg.getPersistentHandle(slot.getValueType()), labelHandle});
        this.getIndex().addEntry(this.slotToByteArray(slot), handle);
        return handle;
    }

    @Override
    public void release(HGPersistentHandle handle) {
        Object slot = this.make(handle, null, null);
        this.getIndex().removeAllEntries(this.slotToByteArray((Slot)slot));
        this.hg.getStore().removeLink(handle);
    }

    @Override
    public boolean subsumes(Object general, Object specific) {
        return false;
    }

    @Override
    public HGSearchResult<HGPersistentHandle> find(Slot key) {
        byte[] asByteArray = this.slotToByteArray(key);
        return this.getIndex().find(asByteArray);
    }

    @Override
    public Iterator<String> getDimensionNames() {
        if (this.projections == null) {
            this.initProjections();
        }
        return this.projections.keySet().iterator();
    }

    @Override
    public HGProjection getProjection(String dimensionName) {
        if (this.projections == null) {
            this.initProjections();
        }
        return this.projections.get(dimensionName);
    }

    private synchronized void initProjections() {
        if (this.projections != null) {
            return;
        }
        this.projections = new HashMap();
        this.projections.put(LABEL_DIMENSION, new LabelProjection());
        this.projections.put(VALUE_TYPE_DIMENSION, new ValueTypeProjection());
    }

    private final class ValueTypeProjection
    implements HGProjection {
        private int[] layoutPath = new int[]{0};

        private ValueTypeProjection() {
        }

        @Override
        public String getName() {
            return SlotType.VALUE_TYPE_DIMENSION;
        }

        @Override
        public HGHandle getType() {
            return SlotType.this.hg.getTypeSystem().getTypeHandle(Top.class);
        }

        @Override
        public Object project(Object value) {
            return ((Slot)value).getValueType();
        }

        @Override
        public void inject(Object slot, Object valueType) {
            ((Slot)slot).setValueType((HGHandle)valueType);
        }

        @Override
        public int[] getLayoutPath() {
            return this.layoutPath;
        }
    }

    private final class LabelProjection
    implements HGProjection {
        private final int[] layoutPath = new int[]{1};

        private LabelProjection() {
        }

        @Override
        public String getName() {
            return SlotType.LABEL_DIMENSION;
        }

        @Override
        public HGHandle getType() {
            return SlotType.this.hg.getTypeSystem().getTypeHandle(String.class);
        }

        @Override
        public Object project(Object value) {
            return ((Slot)value).getLabel();
        }

        @Override
        public void inject(Object slot, Object label) {
            ((Slot)slot).setLabel((String)label);
        }

        @Override
        public int[] getLayoutPath() {
            return this.layoutPath;
        }
    }
}

