/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.atom.AtomProjection;
import org.hypergraphdb.atom.HGAtomRef;
import org.hypergraphdb.type.AtomRefType;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.HGCompositeType;
import org.hypergraphdb.type.HGProjection;
import org.hypergraphdb.type.LinkRecord;
import org.hypergraphdb.type.Record;
import org.hypergraphdb.type.Slot;
import org.hypergraphdb.type.SlotBasedProjection;
import org.hypergraphdb.type.TypeUtils;
import org.hypergraphdb.util.HGUtils;

public class RecordType
implements HGCompositeType {
    protected ArrayList<HGHandle> slots = new ArrayList();
    protected HyperGraph graph;
    protected HGHandle thisHandle;
    private HashMap<String, HGProjection> projections = null;
    private HashMap<HGHandle, HGAtomRef.Mode> refModes = null;

    private synchronized void initProjections() {
        if (this.projections != null) {
            return;
        }
        HashMap<String, SlotBasedProjection> tmp = new HashMap<String, SlotBasedProjection>();
        int i = 0;
        while (i < this.slots.size()) {
            Slot slot = (Slot)this.graph.get(this.slots.get(i));
            tmp.put(slot.getLabel(), new SlotBasedProjection(slot, new int[]{i++}));
        }
        this.projections = tmp;
    }

    public synchronized HGAtomRef.Mode getReferenceMode(HGHandle slot) {
        if (this.refModes == null) {
            this.refModes = new HashMap();
            HGSearchResult<?> rs = null;
            try {
                if (this.thisHandle == null) {
                    this.thisHandle = this.graph.getHandle(this);
                }
                List<AtomProjection> L = HGQuery.hg.getAll(this.graph, HGQuery.hg.and(HGQuery.hg.type(AtomProjection.class), HGQuery.hg.incident(this.thisHandle), HGQuery.hg.orderedLink(this.thisHandle, this.graph.getHandleFactory().anyHandle())));
                for (AtomProjection l : L) {
                    HGHandle slotHandle = (HGHandle)HGQuery.hg.findOne(this.graph, HGQuery.hg.eq(new Slot(l.getName(), l.getProjectionValueType())));
                    this.refModes.put(slotHandle, l.getMode());
                }
            }
            catch (RuntimeException ex) {
                this.refModes = null;
                throw ex;
            }
            finally {
                HGUtils.closeNoException(rs);
            }
        }
        return this.refModes.get(slot);
    }

    public void setThisHandle(HGHandle thisHandle) {
        this.thisHandle = thisHandle;
    }

    @Override
    public Iterator<String> getDimensionNames() {
        if (this.projections == null) {
            this.initProjections();
        }
        return this.projections.keySet().iterator();
    }

    @Override
    public HGProjection getProjection(String dimensionName) {
        if (this.projections == null) {
            this.initProjections();
        }
        return this.projections.get(dimensionName);
    }

    public List<HGHandle> getSlots() {
        return this.slots;
    }

    public void addSlot(HGHandle slot) {
        if (!this.slots.contains(slot)) {
            this.slots.add(slot);
        }
    }

    public void remove(HGHandle slot) {
        this.slots.remove(slot);
    }

    public void removeAt(int i) {
        this.slots.remove(i);
    }

    public HGHandle getAt(int i) {
        return this.slots.get(i);
    }

    public int slotCount() {
        return this.slots.size();
    }

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        this.graph = hg2;
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        HGPersistentHandle[] layout;
        if (this.graph.getHandleFactory().nullHandle().equals(handle)) {
            return null;
        }
        Record result = null;
        HGHandle[] targets = HGUtils.EMPTY_HANDLE_ARRAY;
        if (targetSet != null && (targets = targetSet.deref()) == null) {
            targets = HGUtils.EMPTY_HANDLE_ARRAY;
        }
        result = targets.length > 0 ? new LinkRecord(this.graph.getHandle(this), targets) : new Record(this.graph.getHandle(this));
        TypeUtils.setValueFor(this.graph, handle, result);
        HGPersistentHandle[] hGPersistentHandleArray = layout = this.slots.isEmpty() ? HGUtils.EMPTY_HANDLE_ARRAY : this.graph.getStore().getLink(handle);
        if (layout.length != this.slots.size() * 2) {
            throw new HGException("RecordType.make: Record value of handle " + handle + " does not match record type number of slots.");
        }
        for (int i = 0; i < this.slots.size(); ++i) {
            HGHandle slotHandle = this.getAt(i);
            Object value = null;
            if (!layout[2 * i + 1].equals(this.graph.getHandleFactory().nullHandle())) {
                HGAtomRef.Mode refMode = this.getReferenceMode(slotHandle);
                if (refMode != null) {
                    AtomRefType refType = (AtomRefType)this.graph.getTypeSystem().getAtomType(HGAtomRef.class);
                    value = refType.make(layout[2 * i + 1], null, null);
                } else {
                    value = TypeUtils.makeValue(this.graph, layout[2 * i + 1], this.graph.getTypeSystem().getType(layout[2 * i]));
                }
            }
            result.set((Slot)this.graph.get(slotHandle), value);
        }
        return result;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        if (instance == null) {
            return this.graph.getHandleFactory().nullHandle();
        }
        HGPersistentHandle handle = TypeUtils.getNewHandleFor(this.graph, instance);
        if (this.slots.isEmpty()) {
            return handle;
        }
        if (!(instance instanceof Record)) {
            throw new HGException("RecordType.store: object is not of type Record.");
        }
        Record record = (Record)instance;
        HGPersistentHandle[] layout = new HGPersistentHandle[this.slots.size() * 2];
        for (int i = 0; i < this.slots.size(); ++i) {
            HGHandle slotHandle = this.getAt(i);
            Slot slot = (Slot)this.graph.get(slotHandle);
            Object value = record.get(slot);
            if (value == null) {
                layout[2 * i] = this.graph.getPersistentHandle(slot.getValueType());
                layout[2 * i + 1] = this.graph.getHandleFactory().nullHandle();
                continue;
            }
            HGAtomRef.Mode refMode = this.getReferenceMode(slotHandle);
            if (refMode == null) {
                HGHandle actualTypeHandle = this.graph.getTypeSystem().getTypeHandle(value.getClass());
                if (actualTypeHandle == null) {
                    actualTypeHandle = slot.getValueType();
                } else if (actualTypeHandle.equals(this.graph.getTypeSystem().getTop())) {
                    throw new HGException("Got TOP type for value for Java class " + value.getClass());
                }
                HGAtomType type = this.graph.getTypeSystem().getType(actualTypeHandle);
                layout[2 * i] = this.graph.getPersistentHandle(actualTypeHandle);
                try {
                    layout[2 * i + 1] = TypeUtils.storeValue(this.graph, value, type);
                    continue;
                }
                catch (HGException ex) {
                    throw new HGException("Failed on slot '" + slot.getLabel() + "' of class " + value.getClass(), ex);
                }
            }
            layout[2 * i] = this.graph.getPersistentHandle(slot.getValueType());
            if (value instanceof HGAtomRef) {
                AtomRefType refType = (AtomRefType)this.graph.getTypeSystem().getAtomType(HGAtomRef.class);
                layout[2 * i + 1] = refType.store((HGAtomRef)value);
                continue;
            }
            throw new HGException("Slot " + slot.getLabel() + " should have an atom reference for record " + this.graph.getHandle(this));
        }
        this.graph.getStore().store(handle, layout);
        return handle;
    }

    @Override
    public void release(HGPersistentHandle handle) {
        if (this.slots.isEmpty() || this.graph.getHandleFactory().nullHandle().equals(handle)) {
            return;
        }
        HGPersistentHandle[] layout = this.graph.getStore().getLink(handle);
        if (layout == null) {
            System.out.println("oops, no data for : " + handle);
        }
        if (layout.length != this.slots.size() * 2) {
            throw new HGException("RecordType.remove: Record value of handle " + handle + " does not match record type number of slots.");
        }
        for (int i = 0; i < this.slots.size(); ++i) {
            HGHandle slotHandle = this.getAt(i);
            HGAtomType type = this.getReferenceMode(slotHandle) == null ? this.graph.getTypeSystem().getType(layout[2 * i]) : this.graph.getTypeSystem().getAtomType(HGAtomRef.class);
            int j = 2 * i + 1;
            if (layout[j].equals(this.graph.getHandleFactory().nullHandle()) || TypeUtils.isValueReleased(this.graph, layout[j])) continue;
            TypeUtils.releaseValue(this.graph, type, layout[j]);
            type.release(layout[j]);
        }
        this.graph.getStore().removeLink(handle);
    }

    @Override
    public boolean subsumes(Object general, Object specific) {
        return false;
    }

    public boolean equals(Object other) {
        if (!(other instanceof RecordType)) {
            return false;
        }
        RecordType otherR = (RecordType)other;
        if (this.slots.size() != otherR.slots.size()) {
            return false;
        }
        for (int i = 0; i < this.slots.size(); ++i) {
            if (this.slots.get(i).equals(otherR.slots.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String res = "";
        for (int i = 0; i < this.slots.size(); ++i) {
            String n = ((Slot)this.graph.get(this.getAt(i))).getValueType().getClass().getName();
            res = res + n.substring(n.lastIndexOf(46) + 1);
            if (i == this.slots.size() - 1) continue;
            res = res + "/";
        }
        return res;
    }
}

